#!/bin/bash

#debug="yes"
echoerror()
{
	tput setaf 1
	echo "nok"
	echo -e $1
	tput sgr0
	exit 1
}

launch_ssh_command()
{
	ipsshcom=$1
	commandlaunchssh=$2
	backgroundssh=$3
	returntext=''
	[ "$debug" = "yes" ] && echo "ssh root@$ipsshcom \"$commandlaunchssh\""
	if [ "$backgroundssh" = "yes" ]; then
		ssh root@$ipsshcom "$commandlaunchssh" &
	else
		returntext=`ssh root@$ipsshcom "$commandlaunchssh"`
	fi
}

init_nufw()
{
	[ ! -x /usr/bin/pwgen ] && echo "installer pwgen" && exit 1
	[ ! -x /bin/netcat ] && echo "installer netcat" && exit 1
	pedago="192.168.233.1"
	bastionpedago="192.168.233.210"
	admin="192.168.234.1"
	bastionadmin="192.168.234.210"
	killall netcat > /dev/null 2> /dev/null
	launch_ssh_command $pedago "killall -q netcat > /dev/null 2> /dev/null"
	launch_ssh_command $admin "killall -q netcat > /dev/null 2> /dev/null"
	echo -n "IPSOURCE      	IPDEST      	PORT	FW1	FW2	GUEST	ELEVES	PROFS"
}

is_local ()
{
	ifconfig | grep -q $1
}

launch_listen_netcat()
{ 
	is_local $destip
	if [ ! $? = 0 ]; then
		if [ ! $redirectport1 = '-' ]; then
		       [ "$debug" = "yes" ] && echo "netcat -l -p $redirectport1 -c \"/bin/echo '$fw1message'\""
		       netcat -l -p $redirectport1 -c "/bin/echo '$fw1message'" 2> /dev/null &
		fi
		if [ ! $redirectport2 = '-' ]; then
		       [ "$debug" = "yes" ] && echo "netcat -l -p $redirectport2 -c \"/bin/echo '$fw2message'\""
		       netcat -l -p $redirectport2 -c "/bin/echo '$fw2message'" 2> /dev/null &
	       	fi
		launch_ssh_command $destip "netcat -l -p $destport -c \"/bin/echo '$okmessage'\" 2> /dev/null" "yes"
	else
		[ "$debug" = "yes" ] && echo "netcat -l -p $destport -c \"/bin/echo '$okmessage'\""
		netcat -l -p $destport -c "/bin/echo '$okmessage'" 2> /dev/null &
	fi
}

disconnect_nutcpc()
{
	launch_ssh_command $srcip "./nutcpc -k > /dev/null 2> /dev/null"
}

connect_nutcpc()
{
	if [ $user = "prof" ]; then
		nuuser=m.gourdin
		nupass=o
	elif [ $user = "eleve" ]; then
		nuuser=leo.bontemps
		nupass=o
	else
		echoerror "unknown group $user"
	fi
	cmd="./nutcpc -U $nuuser -H $ipnufw -P $nupass > /dev/null 2> /dev/null"
	launch_ssh_command $srcip "$cmd"
	if [ ! $? = 0 ]; then
		echoerror "ssh root@$srcip $cmd\ncan't identify $nuuser"
	fi
}

test_connect()
{
	disconnect_nutcpc
	sleep 1
	if [ $srcip = $pedago ]; then
		ipnufw=$bastionpedago
	elif [  $srcip = $admin ]; then
		ipnufw=$bastionadmin
	else
		echoerror "unknown ip for nufw"
	fi
	if [ $user = "eleve" ] || [ $user = "prof" ]; then
		connect_nutcpc
	fi
}

test_port()
{
	returntest=$1
	user=$2
	idmessage=`pwgen 10 1`
	okmessage="nufw rocks $idmessage"
	pbmessage="nufw nok $idmessage"
	fw1message="nufw redirect $redirectport1 $idmessage"
	fw2message="nufw redirect $redirectport2 $idmessage"
	bugmessage="bug with the script"
	launch_listen_netcat $destport $returntest
	if [ $returntest = 0 ]; then
	       message=$okmessage
	elif [ $returntest = 1 ]; then
	       message=$pbmessage
	elif [ $returntest = 2 ]; then
	       	message=$fw1message
	elif [ $returntest = 3 ]; then
	       	message=$fw2message
	else
		echoerror "Unknown return code test (should be 0, 1 or 2) : $returntest"
	fi
	is_local $srcip
	if [ ! $? = 0 ]; then
		test_connect
		launch_ssh_command $srcip "netcat -w 1 -q 1 $destip $destport 2> /dev/null"
		if [ ! $? = 0 ]; then
			returnnc=`netcat -w 1 -q 1 $destip $destport 2> /dev/null`
			[ "$debug" = "yes" ] && echo "returnnc: $returnnc"
			[ "$returnnc" = "$okmessage" ] && returntext=$pbmessage || returntext=$bugmessage
		fi
	else
		[ ! $user = "non-identifie" ] && echoerror "only non-identifie for localhost"
		sleep 1
		[ "$debug" = "yes" ] && echo "netcat -w 1 -q 1 $destip $destport"
		returntext=`netcat -w 1 -q 1 $destip $destport 2> /dev/null`
		if [ ! $? = 0 ]; then
			returntext=$bugmessage
		fi
	fi
	if [ "$returntext" = "$message" ]; then
		# message ok
		[ $returntest = 0 ] && color="2"
		[ $returntest = 1 ] && color="3"
		[ $returntest = 2 ] && color="6"
		tput setaf $color
		echo -n "ok	"
		tput sgr0
		# vire les netcats locaux
		killall -q netcat > /dev/null 2> /dev/null
	else
		# message d'erreur
		namesrc=$srcip
		[ "$srcip" = "$pedago" ] && namesrc="pedago"
		[ "$srcip" = "$admin" ] && namesrc="admin"
		[ "$srcip" = "$bastionpedago" ] && namesrc="bastionpedago"
		[ "$srcip" = "$bastionadmin" ] && namesrc="bastionadmin"
		namedst=$destip
		[ "$destip" = "$pedago" ] && namedst="pedago"
		[ "$destip" = "$admin" ] && namedst="admin"
		[ "$destip" = "$bastionpedago" ] && namedst="bastionpedago"
		[ "$destip" = "$bastionadmin" ] && namedst="bastionadmin"
		prevu=""
		[ "$message" = "$okmessage" ] && prevu="laisser passer"
		[ "$message" = "$pbmessage" ] && prevu="bloquer"
		[ "$message" = "$fw1message" ] && prevu="rediriger vers $redirectport1"
		[ "$message" = "$fw2message" ] && prevu="rediriger vers $redirectport2"
		recu=""
		[ "$returntext" = "$okmessage" ] && recu="laisse passer"
		[ "$returntext" = "$pbmessage" ] && recu="bloque"
		[ "$returntext" = "$fw1message" ] && recu="redirige vers $redirectport1"
		[ "$returntext" = "$fw2message" ] && recu="redirige vers $redirectport2"
		if [ ! "$prevu" = "" ] && [ ! "$recu" = "" ]; then
			 echoerror "de $namesrc vers $namedst : devrait $prevu mais $recu"
		else
			echoerror "prevu : \"$message\" - recu : \"$returntext\""
		fi
	fi	
}

test_nufw()
{
	srcip=$1
	destip=$2
	destport=$3
	redirectport1=$4
	redirectport2=$5
	decnonid=$6
	deceleve=$7
	decprof=$8
	echo
	echo -n "$srcip	$destip	$destport	$redirectport1	$redirectport2	"
	if [ ! $decnonid = '-' ]; then
		test_port $decnonid "non-identifie"
	else
		echo -n "-	"
	fi
	if [ ! $deceleve = '-' ]; then
		test_port $deceleve "eleve"
	else
		echo -n "-	"
	fi
	if [ ! $decprof = '-' ]; then
		test_port $decprof "prof"
	else
		echo -n "-	"
	fi
}

init_nufw
#test_nufw from    to             toport fw1    fw2    decisions
#decisions : 0-ACCEPT, 1-DENY, 2-FORWARD1, 3-FORWARD2 for nufwguest, eleves, profs)
test_nufw  $admin  $pedago        2334   -      -      0 0 0
test_nufw  $admin  $pedago        2335   -      -      1 0 0
test_nufw  $admin  $pedago        2338   -      -      1 1 0
test_nufw  $admin  $pedago        2339   3120   -      1 2 0
test_nufw  $admin  $pedago        8500   3120   -      2 2 0
test_nufw  $admin  $pedago        143    3120   3121   2 2 3

test_nufw  $admin  $pedago        194    -      -      1 0 0
test_nufw  $admin  $pedago        994    -      -      1 1 1
test_nufw  $admin  $pedago        6669   -      -      1 0 0
test_nufw  $admin  $pedago        6668   -      -      1 0 0
test_nufw  $admin  $pedago        110    3120  3121    1 2 3
test_nufw  $admin  $pedago        995  3120     -      2 2 0


test_nufw  $pedago  $admin        2334   -      -      1 1 1
test_nufw  $pedago  $admin        2335   -      -      1 1 0
test_nufw  $pedago  $admin        2338   -      -      1 0 0
test_nufw  $pedago  $admin        2339   3120   -      1 2 1
test_nufw  $pedago  $admin        8500   3120   -      2 2 1
test_nufw  $pedago  $admin        143    3120   3121   2 2 3

test_nufw  $pedago  $admin        194    -      -      1 0 0
test_nufw  $pedago  $admin        994    -      -      1 0 0
test_nufw  $pedago  $admin        6669   -      -      1 0 0
test_nufw  $pedago  $admin        110    -      -      1 0 0
test_nufw  $pedago  $admin        995    -      -      1 0 0
test_nufw  $pedago  $admin        137    3120   3121   1 2 3 

echo
