#!/usr/bin/env python
# -*- coding: UTF-8 -*-

import unittest

import os, shutil, glob

SITE_ROOT = "./sites/abcdefgh"

class TestAgentCollecteur(unittest.TestCase):
    """Les relations entre le collecteur et l'arborescence du système de fichiers zephir
    """

    def setUp(self):
        """Mise en place d'artéfacts de fichiers de configurations 
        """
        # fichiers de configuration de test
        # agents.cfg
        shutil.copy("../agents.cfg", "../agents.cfg.bak")
        shutil.copy("agents.cfg", "../agents.cfg")
        # config.py
        shutil.copy("../config.py", "../config.py.bak")
        shutil.copy("config.py", "../config.py")
        # création du collecteur
        from zephir.monitor.collecteur import AgentCollecteur
        self.collect = AgentCollecteur("abcdefgh")

    def tearDown(self):
        """Restauration des fichiers de configuration usuels
        """
        # restauration des fichiers de configuration
        os.rename("../agents.cfg.bak", "../agents.cfg")
        os.rename("../config.py.bak", "../config.py")
        # purge de l'arborescence dirdbm
        for f in glob.glob(SITE_ROOT+"/dirdbm/*"):
            os.unlink(f)
        os.removedirs(SITE_ROOT+"/dirdbm")
        
    def test_arboDirDBM(self):
        """Crée la racine de l'arborescence dirdbm
        """
        if not os.path.isdir(SITE_ROOT+"/dirdbm") :
            raise Exception

    def test_get_agent_info(self):
        """Infos de tableau de bord d'un agent
        """
        vect = ('ls', "Listing des fichiers d'un r\xe9pertoire", '1', '16/02/2004')
        self.assertEqual(self.collect.get_agent_info(SITE_ROOT+"/xml/ls.xml"), vect)

    def test_get_serveur(self):
        """Récupère les informations relatives à un serveur (une somme d'agents)
        """
        l = [('ls', "Listing des fichiers d'un r\xe9pertoire", '1', '16/02/2004'), ('mem', 'Bilan de la m\xe9moire', '1', '16/02/2004'), ('reseau', 'Informations reseau (configuration des cartes ethernet)', '1', '16/02/2004'), ('uptime', "Informations d'utilisation syst\xe8me", '1', '16/02/2004')]
        self.assertEqual(self.collect.get_serveur(), l)
        
    def test_pickle(self):
        """Sérialisation de la somme d'agents d'un serveur
        dans l'arborescence dirdbm
        """
        if not len(glob.glob(SITE_ROOT+"/dirdbm/*")):
            raise Exception, "pas d'arbo dirdbm"



class TestServeurStatus(unittest.TestCase):
    """Le statut d'un serveur pour affichage
    """

    def setUp(self):
        """Mise en place d'artéfacts de fichiers de configurations 
        """
        # fichiers de configuration de test
        # agents.cfg
        shutil.copy("../agents.cfg", "../agents.cfg.bak")
        shutil.copy("agents.cfg", "../agents.cfg")
        # config.py
        shutil.copy("../config.py", "../config.py.bak")
        shutil.copy("config.py", "../config.py")
        # création du collecteur
        from zephir.monitor.collecteur import AgentCollecteur, ServeurStatus

        self.collect = AgentCollecteur("abcdefgh")
        self.serv = ServeurStatus("abcdefgh")

    def tearDown(self):
        """Restauration des fichiers de configuration usuels
        """
        # restauration des fichiers de configuration
        os.rename("../agents.cfg.bak", "../agents.cfg")
        os.rename("../config.py.bak", "../config.py")
        # purge de l'arborescence dirdbm
        for f in glob.glob(SITE_ROOT+"/dirdbm/*"):
            os.unlink(f)
        os.removedirs(SITE_ROOT+"/dirdbm")

    def test_unpickle(self):
        """Pickle dirdbm des informations de tableau de bord
        (côté zephir)
        """
        d = {'mem': ('Bilan de la m\xe9moire', '1', '16/02/2004'), 'uptime': ("Informations d'utilisation syst\xe8me", '1', '16/02/2004'), 'reseau': ('Informations reseau (configuration des cartes ethernet)', '1', '16/02/2004'), 'ls': ("Listing des fichiers d'un r\xe9pertoire", '1', '16/02/2004')}
        self.assertEqual(self.serv._serveur_unpickle(), d)

    def test_status(self):
        """Le statut d'un serveur 
        """
        status = self.serv.get_status()
        self.assertEqual(status, 1)

        
if __name__ == "__main__" :
    unittest.main()
    
