# -*- coding: UTF-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
###########################################################################
"""
Affichage des imprimantes CUPS et de leur état
"""
from twisted.internet.utils import getProcessOutput
from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import status_to_img


PRINTER_CHECK = '/usr/share/zephir/monitor/bin/printers.sh'

class Printers(Agent):

    def __init__(self, name,
                 **params):
        Agent.__init__(self, name, **params)
        self.table = TableData([
            ('status', "état", {'align':'center'}, status_to_img),
            ('printer', "Imprimante", {'align':'left'}, None),
            ])
        self.data = [self.table]

    def measure(self):
        test = getProcessOutput(PRINTER_CHECK,
                                env  = {'LC_ALL': 'C'},
                                errortoo = 1)
        test.addCallbacks(self.measure_process, self.measure_error)
        return test

    def measure_process(self, result):
        result = result.decode()
        l = []
        lines = result.splitlines()
        for line in lines :
            if line.startswith('printer') or line.startswith("l’imprimante"):
                if 'disabled' in line or 'désactivée' in line:
                    l.append( { 'printer' : line.split()[1],
                                'status'  : 'Off' } )
                    self.measure_data[line.split()[1]] = 'Off'
                elif 'is idle' in line or ' activée' in line:
                    l.append( { 'printer' : line.split()[1],
                                'status'  : 'On' } )
                    self.measure_data[line.split()[1]] = 'On'
        if l == [] :
            l.append( { 'printer' : '** Aucune imprimante détectée **',
                        'status'  : '---' } )

        return { 'statistics' : l}

    def measure_error(self, result):
        return { 'statistics' : [{ 'printer' : '** Mesure impossible **',
                                   'status'  : '---' }] }
    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value['statistics']

    def check_status(self):
        #if self.last_measure is not None:
        #    for service in self.last_measure.value['s']:
        #        if service['status'] != 'On':
        #            return status.Error()
        #else:
        #    # pas de mesure connue
        #    return status.Unknown()
        return status.OK()
