# -*- coding: UTF-8 -*-

#########################################################################
# Agent Zéphir maj
# Copyright © 2014 Pôle de Compétence EOLE <eole@ac-dijon.fr>
#
# License CeCILL:
#  * in french: http://www.cecill.info/licences/Licence_CeCILL_V2-fr.html
#  * in english http://www.cecill.info/licences/Licence_CeCILL_V2-en.html
#########################################################################

"""
Agent Maj
"""

from zephir.monitor.agentmanager.agent import Agent
from zephir.monitor.agentmanager.data import TableData
from zephir.monitor.agentmanager import status
from zephir.monitor.agentmanager.util import status_to_img
from pyeole.diagnose import test_maj, test_maj_reconfigure, test_need_reboot
import os


class Maj(Agent):
    """
    Utilisateurs connectes
    """
    def __init__(self, name, **params):
        Agent.__init__(self, name, **params)
        self.status = status.Unknown()
        self.table = TableData([
            ('status', 'état', {'align':'center'}, status_to_img),
            ('msg', 'message', {'align':'left'}, None)
        ])
        self.data = [self.table]

    def measure(self):
        retmaj = test_maj()
        retmajreconf = test_maj_reconfigure()
        retmajreconf['msg'] = 'Reconfigure effectué : ' + retmajreconf['msg']
        retneedreboot = test_need_reboot()
        retneedreboot = {'status': {True: 'Off', False: 'On'}.get(retneedreboot),
                         'msg': 'Reboot nécessaire : ' + {True: 'oui', False: 'non'}.get(retneedreboot)}
        stats = [i['status'] for i in [retmaj, retmajreconf, retneedreboot]]
        if 'Off' in stats:
            self.status = status.Error()
        elif 'Warn' in stats:
            self.status = status.Warn()
        elif 'On' in stats:
            self.status = status.OK()
        else:
            self.status = status.Unknown()
        return [retmaj, retmajreconf, retneedreboot]

    def check_status(self):
        return self.status

    def write_data(self):
        Agent.write_data(self)
        if self.last_measure is not None:
            self.table.table_data = self.last_measure.value
