# -*- coding: utf-8 -*-
###########################################################################
# Eole NG - 2007
# Copyright Pole de Competence Eole  (Ministere Education - Academie Dijon)
# Licence CeCill  cf /root/LicenceEole.txt
# eole@ac-dijon.fr
#
# regen_certs.py
#
# script de regénération des certificats ssl
#
###########################################################################
from creole import cert
from service_restart import do_restart, prog_restart_differe
from zephir.lib_zephir import log
from creole.config import VIRTROOT, VIRTBASE
import os, glob

class RegenCertError(Exception): pass

def regen_ssl_certs():
    # procédure à lancer et services à redémarrer pour regénérer les certificats
    ssl_serv = ['apache2','ead-server','ead-web','zephir','zephir_web','eole-sso','sentinelle','eoleflask','eoleadmin','nginx']
    backups = []
    try:
        for ssl_file in [cert.cert_file, cert.key_file]:
            if os.path.isfile(ssl_file):
                os.rename(ssl_file, ssl_file+".bak")
                backups.append(ssl_file+".bak")
        # lancement de la procédure de génération du certificat
        cert.gen_certs()
    except:
        for backup_file in backups:
             os.rename(backup_file, backup_file.rstrip(".bak"))
        raise RegenCertError("Erreur de génération des certificats web, anciens fichiers remis en place")
    else:
        # mise à jour des certificats dans tous les conteneurs
        container_dirs = glob.glob(os.path.join(VIRTROOT, '*', VIRTBASE, cert.cert_dir.lstrip('/')))
        for cont_dir in container_dirs:
            os.system('/bin/cp -a %s/* %s/' % (cert.cert_dir, cont_dir))
        # redémarrage des services utilisant les certificats
        for service in ssl_serv:
            try:
                do_restart(service, ignore_missing=True)
            except:
                # une exception est levée si le service est désactivé
                pass
        # redémarrage spécifique : z_stats
        log('SERVICE_RESTART',-2,"Le service z_stats sera relancé dans 1 minute")
        prog_restart_differe("1 minutes", 'z_stats')
