.TH sane\-fujitsu 5 "24 Mar 2023" "@PACKAGEVERSION@" "SANE Scanner Access Now Easy"
.IX sane\-fujitsu

.SH NAME
sane\-fujitsu \- SANE backend for Fujitsu and Ricoh fi series scanners

.SH DESCRIPTION
The
.B sane\-fujitsu
library implements a SANE (Scanner Access Now Easy) backend which provides
access to most Fujitsu flatbed and ADF scanners, and the subsequent Ricoh models.

This document describes backend version 140.

.SH SUPPORTED HARDWARE
This version supports every known model which speaks the Fujitsu SCSI and
SCSI\-over\-USB protocols. Specifically, the SCSI M309x and M409x series, the
SCSI fi\-series, and most of the USB fi\-, ScanSnap, & iX series scanners are
supported.  Please see the list at
.I http://www.sane\-project.org/sane\-supported\-devices.html
for details.

This backend may support other Fujitsu or newer Ricoh scanners. The best
way to determine level of support is to test the scanner directly,
or to collect a trace of the windows driver in action.
Please contact the author for help or with test results.

.SH UNSUPPORTED HARDWARE
The following scanners are known NOT to work with this backend,
either because they have an unsupported chipset, or an unsupported
interface type. Some of these scanners may be supported by another
backend.
.PP
.RS
.ft CR
.nf
\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-\-
SCSI:        SERIAL:      USB:
\-\-\-\-\-\-\-\-\-\-\-\- \-\-\-\-\-\-\-\-\-\-\-\- \-\-\-\-\-\-\-\-\-\-\-\-
ScanStation  M3093E/DE/EX fi\-4110EOX/2
ScanPartner  M3096EX      fi\-4010CU
SP\-Jr        M3097E+/DE   S300/S300M
SP\-10/10C    M3099A/EH/EX S1300/S1100
SP\-15C/300C               fi\-60F/65F
SP\-600C/620C              fi\-5015C
                          SP\-2x/3x
.fi
.ft R
.RE
.P

.SH OPTIONS
Effort has been made to expose all hardware options, including:
.PP
.B source s
.RS
Selects the source for the scan. Options
may include "Flatbed", "ADF Front", "ADF Back", "ADF Duplex", "Card Front", "Card Back", "Card Duplex".
.RE
.PP
.B mode m
.RS
Selects the mode for the scan. Options
may include "Lineart", "Halftone", "Gray", and "Color".
.RE
.PP
.B resolution, y\-resolution
.RS
Controls scan resolution. Setting
.B \-\-resolution
also sets
.BR \-\-y\-resolution,
though this behavior is overridden by some frontends.
.RE
.PP
.B tl\-x, tl\-y, br\-x, br\-y
.RS
Sets scan area upper left and lower right coordinates. These are renamed
.B t, l, x, y
by some frontends.
.RE
.PP
.B page\-width, page\-height
.RS
Sets paper size. Used by scanner to determine centering of scan
coordinates when using the ADF (Automatic Document Feeder) and to detect
double feed errors.
.RE
.PP
Other options will be available based on the capabilities of the scanner:
machines with IPC or DTC will have additional enhancement options, those
with CMP will have compression options, those with a printer will have a
group of endorser options.

Additionally, several 'software' options are exposed by the backend. These
are reimplementations of features provided natively by larger scanners, but
running on the host computer. This enables smaller machines to have similar
capabilities. Please note that these features are somewhat simplistic, and
may not perform as well as the native implementations. Note also that these
features all require that the driver cache the entire image in memory. This
will almost certainly result in a reduction of scanning speed.
.PP
.B swcrop
.RS
Requests the driver to detect the extremities of the paper within the larger
image, and crop the empty edges.
.RE
.PP
.B swdeskew
.RS
Requests the driver to detect the rotation of the paper within the larger
image, and counter the rotation.
.RE
.PP
.B swdespeck X
.RS
Requests the driver to find and remove dots of X diameter or smaller from the
image, and fill the space with the average surrounding color.
.RE

Use
.I 'scanimage \-\-help'
to get a list, but be aware that some options may
be settable only when another option has been set, and that advanced options
may be hidden by some frontend programs.

.SH CONFIGURATION FILE
The configuration file
.I fujitsu.conf
is used to tell the backend how to look
for scanners, and provide options controlling the operation of the backend.
This file is read each time the frontend asks the backend for a list
of scanners, generally only when the frontend starts. If the configuration
file is missing, the backend will be unable to locate any scanners.
.PP
Scanners can be specified in the configuration file in 4 ways:
.PP
"scsi FUJITSU"
.RS
Requests backend to search all scsi buses in the system for a device
which reports itself to be a scanner made by 'FUJITSU'.
.RE
.PP
"scsi /dev/sg0" (or other scsi device file)
.RS
Requests backend to open the named scsi device. Only useful if you have
multiple compatible scanners connected to your system, and need to
specify one. Probably should not be used with the other "scsi" line above.
.RE
.PP
"usb 0x04c5 0x1042" (or other vendor/product ids)
.RS
Requests backend to search all usb buses in the system for a device
which uses that vendor and product id. The device will then be queried
to determine if it is a supported scanner.
.RE
.PP
"usb /dev/usb/scanner0" (or other device file)
.RS
Some systems use a kernel driver to access usb scanners. This method is
untested.
.RE
.PP
The only configuration option supported is "buffer\-size=xxx", allowing you
to set the number of bytes in the data buffer to something other than the
compiled\-in default, 65536 (64K). Some users report that their scanner will
"hang" mid\-page, or fail to transmit the image if the buffer is not large
enough.
.PP
Note: This option may appear multiple times in the configuration file. It only
applies to scanners discovered by 'scsi/usb' lines that follow this option.
.PP
Note: The backend does not place an upper bound on this value, as some users
required it to be quite large. Values above the default are not recommended,
and may crash your OS or lockup your scsi card driver. You have been
warned.
.PP

.SH ENVIRONMENT
The backend uses a single environment variable,
.BR SANE_DEBUG_FUJITSU ,
which enables debugging output to stderr. Valid values are:
.PP
.RS
5  Errors
.br
10 Function trace
.br
15 Function detail
.br
20 Option commands
.br
25 SCSI/USB trace
.br
30 SCSI/USB writes
.br
31 SCSI/USB reads
.br
35 Useless noise
.RE

.SH KNOWN ISSUES
Flatbed units may fail to scan at maximum area, particularly at
high resolution.
.PP
Any model that does not support VPD during inquiry will not function until
an override is added to the backend.
.PP
CCITT Fax compression used by older scanners is not supported.
.PP
JPEG output is supported by the backend, but not by the SANE protocol, so is
disabled in this release. It can be enabled if you rebuild from source.
.PP
Network interfaces are not supported on any scanner model.

.SH CREDITS
m3091 backend: Frederik Ramm
.RI < "frederik a t remote d o t org" >
.br
m3096g backend: Randolph Bentson
.RI < "bentson a t holmsjoen d o t com" >
.br
  (with credit to the unnamed author of the coolscan driver)
.br
fujitsu backend, m3093, fi\-4340C, ipc, cmp, long\-time maintainer:
.br
  Oliver Schirrmeister
.RI < "oschirr a t abm d o t de" >
.br
m3092: Mario Goppold
.RI < "mgoppold a t tbzpariv d o t tcc\-chemnitz dot de" >
.br
fi\-4220C and basic USB support: Ron Cemer
.RI < "ron a t roncemer d o t com" >
.br
fi\-4120, fi\-series color, backend re\-write, jpeg, current maintainer:
  m. allan noah:
.RI < "kitno455 a t gmail d o t com" >

JPEG output and low memory usage support funded by:
  Archivista GmbH
.I www.archivista.ch

Endorser support funded by:
  O A S Oilfield Accounting Service Ltd
  1500, 840 \- 7th Avenue S.W.
  Calgary, Alberta
  T2P 3G2 Canada
  1\-403\-263\-2600
.I  www.oas.ca

Automatic length detection support funded by:
  Martin G. Miller
.I  mgmiller at optonline.net

Hardware donated, software image enhancement and fi-6/7xxx support funded by:
  PFU America, Inc.
.I  fujitsuscanners.com

iX500 support funded by:
  Prefix Computer Services
.I  www.prefixservice.com

.SH "SEE ALSO"
.BR sane (7),
.BR sane\-scsi (5),
.BR sane\-usb (5),
.BR sane\-sp15c (5),
.BR sane\-avision (5),
.BR sane\-epjitsu (5)

.SH AUTHOR
m. allan noah: <kitno455 a t gmail d o t com>
