#!/bin/sh
# SPDX-License-Identifier: BSD-2-Clause
# SPDX-FileCopyrightText: © 2016 Antoine Le Gonidec <vv221@dotslashplay.it>
set -o errexit

###
# Risk of Rain
# send your bug reports to bugs@dotslashplay.it
###

script_version=20250704.1

PLAYIT_COMPATIBILITY_LEVEL='2.32'

GAME_ID='risk-of-rain'
GAME_NAME='Risk of Rain'

ARCHIVE_BASE_GOG_1_NAME='gog_risk_of_rain_2.1.0.6.sh'
ARCHIVE_BASE_GOG_1_MD5='423ea26f877eb8f0d72e04dffffbf81a'
ARCHIVE_BASE_GOG_1_SIZE='180000'
ARCHIVE_BASE_GOG_1_VERSION='1.2.8-gog2.1.0.6'
ARCHIVE_BASE_GOG_1_URL='https://www.gog.com/game/risk_of_rain'

ARCHIVE_BASE_GOG_0_NAME='gog_risk_of_rain_2.1.0.5.sh'
ARCHIVE_BASE_GOG_0_MD5='34f8e1e2dddc6726a18c50b27c717468'
ARCHIVE_BASE_GOG_0_SIZE='180000'
ARCHIVE_BASE_GOG_0_VERSION='1.2.8-gog2.1.0.5'

ARCHIVE_BASE_HUMBLE_0_NAME='Risk_of_Rain_v1.3.0_DRM-Free_Linux_.zip'
ARCHIVE_BASE_HUMBLE_0_MD5='21eb80a7b517d302478c4f86dd5ea9a2'
ARCHIVE_BASE_HUMBLE_0_SIZE='100000'
ARCHIVE_BASE_HUMBLE_0_VERSION='1.3.0-humble160519'
ARCHIVE_BASE_HUMBLE_0_URL='https://www.humblebundle.com/store/risk-of-rain'

CONTENT_PATH_DEFAULT_GOG='data/noarch/game'
CONTENT_PATH_DEFAULT_HUMBLE='.'
CONTENT_GAME_BIN_FILES='
Risk_of_Rain'
CONTENT_GAME_DATA_FILES='
assets'

APP_MAIN_EXE='Risk_of_Rain'
APP_MAIN_ICON='assets/icon.png'

PACKAGES_LIST='
PKG_BIN
PKG_DATA'

PKG_BIN_ARCH='32'
PKG_BIN_DEPENDENCIES_SIBLINGS='
PKG_DATA'
PKG_BIN_DEPENDENCIES_LIBRARIES='
libc.so.6
libcurl.so.4+CURL_OPENSSL_3
libdl.so.2
libgcc_s.so.1
libGL.so.1
libGLU.so.1
libm.so.6
libopenal.so.1
libpthread.so.0
librt.so.1
libssl.so.1.0.0
libstdc++.so.6
libX11.so.6
libXext.so.6
libXrandr.so.2
libXxf86vm.so.1
libz.so.1'

PKG_DATA_ID="${GAME_ID}-data"
PKG_DATA_DESCRIPTION='data'

# Load common functions

PLAYIT_LIB_PATHS="
$PWD
${XDG_DATA_HOME:="${HOME}/.local/share"}/play.it
/usr/local/share/games/play.it
/usr/local/share/play.it
/usr/share/games/play.it
/usr/share/play.it"

if [ -z "$PLAYIT_LIB2" ]; then
	for playit_lib_path in $PLAYIT_LIB_PATHS; do
		if [ -e "${playit_lib_path}/libplayit2.sh" ]; then
			PLAYIT_LIB2="${playit_lib_path}/libplayit2.sh"
			break
		fi
	done
fi
if [ -z "$PLAYIT_LIB2" ]; then
	printf '\n\033[1;31mError:\033[0m\n'
	printf 'libplayit2.sh not found.\n'
	exit 1
fi
# shellcheck source=libplayit2.sh
. "$PLAYIT_LIB2"

# Run the default initialization actions

initialization_default "$@"

# Extract game data

archive_extraction_default

# Include game data

content_inclusion_icons 'PKG_DATA'
content_inclusion_default

# Write launchers

launchers_generation 'PKG_BIN'

# Build packages

packages_generation
print_instructions

# Clean up

working_directory_cleanup

exit 0
