/*
 * Decompiled with CFR 0.152.
 */
package com.mysql.cj.core.authentication;

import com.mysql.cj.core.exceptions.AssertionFailedException;
import com.mysql.cj.core.util.StringUtils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class Security {
    public static void xorString(byte[] from, byte[] to, byte[] scramble, int length) {
        int scrambleLength = scramble.length;
        for (int pos = 0; pos < length; ++pos) {
            to[pos] = (byte)(from[pos] ^ scramble[pos % scrambleLength]);
        }
    }

    public static byte[] scramble411(String password, String seed, String passwordEncoding) {
        byte[] passwordBytes = passwordEncoding == null || passwordEncoding.length() == 0 ? StringUtils.getBytes(password) : StringUtils.getBytes(password, passwordEncoding);
        return Security.scramble411(passwordBytes, StringUtils.getBytes(seed, "ASCII"));
    }

    public static byte[] scramble411(byte[] password, byte[] seed) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AssertionFailedException(ex);
        }
        byte[] passwordHashStage1 = md.digest(password);
        md.reset();
        byte[] passwordHashStage2 = md.digest(passwordHashStage1);
        md.reset();
        md.update(seed);
        md.update(passwordHashStage2);
        byte[] toBeXord = md.digest();
        int numToXor = toBeXord.length;
        for (int i2 = 0; i2 < numToXor; ++i2) {
            toBeXord[i2] = (byte)(toBeXord[i2] ^ passwordHashStage1[i2]);
        }
        return toBeXord;
    }

    private Security() {
    }
}

