/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.ipc;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.SocketTimeoutException;
import java.util.HashMap;
import java.util.Map;
import javax.net.SocketFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configurable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.ObjectWritable;
import org.apache.hadoop.io.UTF8;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.ipc.Client;
import org.apache.hadoop.ipc.VersionedProtocol;
import org.apache.hadoop.net.NetUtils;
import org.apache.hadoop.security.SaslRpcServer;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.hadoop.security.token.SecretManager;
import org.apache.hadoop.security.token.TokenIdentifier;

public class RPC {
    private static final Log LOG = LogFactory.getLog(RPC.class);
    private static ClientCache CLIENTS = new ClientCache();

    private RPC() {
    }

    static Client getClient(Configuration conf) {
        return RPC.CLIENTS.getClient(conf);
    }

    public static VersionedProtocol waitForProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.waitForProxy(protocol, clientVersion, addr, conf, 0, Long.MAX_VALUE);
    }

    static VersionedProtocol waitForProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, long connTimeout) throws IOException {
        return RPC.waitForProxy(protocol, clientVersion, addr, conf, 0, connTimeout);
    }

    static VersionedProtocol waitForProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int rpcTimeout, long connTimeout) throws IOException {
        long startTime = System.currentTimeMillis();
        while (true) {
            IOException ioe;
            try {
                return RPC.getProxy(protocol, clientVersion, addr, conf, rpcTimeout);
            }
            catch (ConnectException se) {
                LOG.info((Object)("Server at " + addr + " not available yet, Zzzzz..."));
                ioe = se;
            }
            catch (SocketTimeoutException te) {
                LOG.info((Object)("Problem connecting to server: " + addr));
                ioe = te;
            }
            if (System.currentTimeMillis() - connTimeout >= startTime) {
                throw ioe;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException ie) {
            }
        }
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return RPC.getProxy(protocol, clientVersion, addr, ugi, conf, factory, 0);
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        UserGroupInformation ugi = UserGroupInformation.getCurrentUser();
        return RPC.getProxy(protocol, clientVersion, addr, ugi, conf, factory, rpcTimeout);
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory) throws IOException {
        return RPC.getProxy(protocol, clientVersion, addr, ticket, conf, factory, 0);
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
        VersionedProtocol proxy;
        long serverVersion;
        if (UserGroupInformation.isSecurityEnabled()) {
            SaslRpcServer.init(conf);
        }
        if ((serverVersion = (proxy = (VersionedProtocol)Proxy.newProxyInstance(protocol.getClassLoader(), new Class[]{protocol}, (InvocationHandler)new Invoker(protocol, addr, ticket, conf, factory, rpcTimeout))).getProtocolVersion(protocol.getName(), clientVersion)) == clientVersion) {
            return proxy;
        }
        throw new VersionMismatch(protocol.getName(), clientVersion, serverVersion);
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf) throws IOException {
        return RPC.getProxy(protocol, clientVersion, addr, conf, NetUtils.getDefaultSocketFactory(conf), 0);
    }

    public static VersionedProtocol getProxy(Class<? extends VersionedProtocol> protocol, long clientVersion, InetSocketAddress addr, Configuration conf, int rpcTimeout) throws IOException {
        return RPC.getProxy(protocol, clientVersion, addr, conf, NetUtils.getDefaultSocketFactory(conf), rpcTimeout);
    }

    public static void stopProxy(VersionedProtocol proxy) {
        if (proxy != null) {
            ((Invoker)Proxy.getInvocationHandler(proxy)).close();
        }
    }

    public static Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, Configuration conf) throws IOException, InterruptedException {
        return RPC.call(method, params, addrs, null, conf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] call(Method method, Object[][] params, InetSocketAddress[] addrs, UserGroupInformation ticket, Configuration conf) throws IOException, InterruptedException {
        Writable[] invocations = new Invocation[params.length];
        for (int i = 0; i < params.length; ++i) {
            invocations[i] = new Invocation(method, params[i]);
        }
        Client client = RPC.CLIENTS.getClient(conf);
        try {
            Writable[] wrappedValues = client.call(invocations, addrs, method.getDeclaringClass(), ticket, conf);
            if (method.getReturnType() == Void.TYPE) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] values = (Object[])Array.newInstance(method.getReturnType(), wrappedValues.length);
            for (int i = 0; i < values.length; ++i) {
                if (wrappedValues[i] == null) continue;
                values[i] = ((ObjectWritable)wrappedValues[i]).get();
            }
            Object[] objectArray = values;
            return objectArray;
        }
        finally {
            RPC.CLIENTS.stopClient(client);
        }
    }

    public static Server getServer(Object instance, String bindAddress, int port, Configuration conf) throws IOException {
        return RPC.getServer(instance, bindAddress, port, 1, false, conf);
    }

    public static Server getServer(Object instance, String bindAddress, int port, int numHandlers, boolean verbose, Configuration conf) throws IOException {
        return RPC.getServer(instance, bindAddress, port, numHandlers, verbose, conf, null);
    }

    public static Server getServer(Object instance, String bindAddress, int port, int numHandlers, boolean verbose, Configuration conf, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
        return new Server(instance, conf, bindAddress, port, numHandlers, verbose, secretManager);
    }

    private static void log(String value) {
        if (value != null && value.length() > 55) {
            value = value.substring(0, 55) + "...";
        }
        LOG.info((Object)value);
    }

    public static class Server
    extends org.apache.hadoop.ipc.Server {
        private Object instance;
        private boolean verbose;

        public Server(Object instance, Configuration conf, String bindAddress, int port) throws IOException {
            this(instance, conf, bindAddress, port, 1, false, null);
        }

        private static String classNameBase(String className) {
            String[] names = className.split("\\.", -1);
            if (names == null || names.length == 0) {
                return className;
            }
            return names[names.length - 1];
        }

        public Server(Object instance, Configuration conf, String bindAddress, int port, int numHandlers, boolean verbose, SecretManager<? extends TokenIdentifier> secretManager) throws IOException {
            super(bindAddress, port, Invocation.class, numHandlers, conf, Server.classNameBase(instance.getClass().getName()), secretManager);
            this.instance = instance;
            this.verbose = verbose;
        }

        @Override
        public Writable call(Class<?> protocol, Writable param, long receivedTime) throws IOException {
            try {
                Invocation call = (Invocation)param;
                if (this.verbose) {
                    RPC.log("Call: " + call);
                }
                Method method = protocol.getMethod(call.getMethodName(), call.getParameterClasses());
                method.setAccessible(true);
                long startTime = System.currentTimeMillis();
                Object value = method.invoke(this.instance, call.getParameters());
                int processingTime = (int)(System.currentTimeMillis() - startTime);
                int qTime = (int)(startTime - receivedTime);
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Served: " + call.getMethodName() + " queueTime= " + qTime + " procesingTime= " + processingTime));
                }
                this.rpcMetrics.addRpcQueueTime(qTime);
                this.rpcMetrics.addRpcProcessingTime(processingTime);
                this.rpcMetrics.addRpcProcessingTime(call.getMethodName(), processingTime);
                if (this.verbose) {
                    RPC.log("Return: " + value);
                }
                return new ObjectWritable(method.getReturnType(), value);
            }
            catch (InvocationTargetException e) {
                Throwable target = e.getTargetException();
                if (target instanceof IOException) {
                    throw (IOException)target;
                }
                IOException ioe = new IOException(target.toString());
                ioe.setStackTrace(target.getStackTrace());
                throw ioe;
            }
            catch (Throwable e) {
                if (!(e instanceof IOException)) {
                    LOG.error((Object)"Unexpected throwable object ", e);
                }
                IOException ioe = new IOException(e.toString());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }
    }

    public static class VersionMismatch
    extends IOException {
        private String interfaceName;
        private long clientVersion;
        private long serverVersion;

        public VersionMismatch(String interfaceName, long clientVersion, long serverVersion) {
            super("Protocol " + interfaceName + " version mismatch. (client = " + clientVersion + ", server = " + serverVersion + ")");
            this.interfaceName = interfaceName;
            this.clientVersion = clientVersion;
            this.serverVersion = serverVersion;
        }

        public String getInterfaceName() {
            return this.interfaceName;
        }

        public long getClientVersion() {
            return this.clientVersion;
        }

        public long getServerVersion() {
            return this.serverVersion;
        }
    }

    private static class Invoker
    implements InvocationHandler {
        private Client.ConnectionId remoteId;
        private Client client;
        private boolean isClosed = false;

        public Invoker(Class<? extends VersionedProtocol> protocol, InetSocketAddress address, UserGroupInformation ticket, Configuration conf, SocketFactory factory, int rpcTimeout) throws IOException {
            this.remoteId = Client.ConnectionId.getConnectionId(address, protocol, ticket, rpcTimeout, conf);
            this.client = CLIENTS.getClient(conf, factory);
        }

        @Override
        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            boolean logDebug = LOG.isDebugEnabled();
            long startTime = 0L;
            if (logDebug) {
                startTime = System.currentTimeMillis();
            }
            ObjectWritable value = (ObjectWritable)this.client.call((Writable)new Invocation(method, args), this.remoteId);
            if (logDebug) {
                long callTime = System.currentTimeMillis() - startTime;
                LOG.debug((Object)("Call: " + method.getName() + " " + callTime));
            }
            return value.get();
        }

        private synchronized void close() {
            if (!this.isClosed) {
                this.isClosed = true;
                CLIENTS.stopClient(this.client);
            }
        }
    }

    private static class ClientCache {
        private Map<SocketFactory, Client> clients = new HashMap<SocketFactory, Client>();

        private ClientCache() {
        }

        private synchronized Client getClient(Configuration conf, SocketFactory factory) {
            Client client = this.clients.get(factory);
            if (client == null) {
                client = new Client(ObjectWritable.class, conf, factory);
                this.clients.put(factory, client);
            } else {
                client.incCount();
            }
            return client;
        }

        private synchronized Client getClient(Configuration conf) {
            return this.getClient(conf, SocketFactory.getDefault());
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void stopClient(Client client) {
            ClientCache clientCache = this;
            synchronized (clientCache) {
                client.decCount();
                if (client.isZeroReference()) {
                    this.clients.remove(client.getSocketFactory());
                }
            }
            if (client.isZeroReference()) {
                client.stop();
            }
        }
    }

    private static class Invocation
    implements Writable,
    Configurable {
        private String methodName;
        private Class[] parameterClasses;
        private Object[] parameters;
        private Configuration conf;

        public Invocation() {
        }

        public Invocation(Method method, Object[] parameters) {
            this.methodName = method.getName();
            this.parameterClasses = method.getParameterTypes();
            this.parameters = parameters;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public Class[] getParameterClasses() {
            return this.parameterClasses;
        }

        public Object[] getParameters() {
            return this.parameters;
        }

        @Override
        public void readFields(DataInput in) throws IOException {
            this.methodName = UTF8.readString(in);
            this.parameters = new Object[in.readInt()];
            this.parameterClasses = new Class[this.parameters.length];
            ObjectWritable objectWritable = new ObjectWritable();
            for (int i = 0; i < this.parameters.length; ++i) {
                this.parameters[i] = ObjectWritable.readObject(in, objectWritable, this.conf);
                this.parameterClasses[i] = objectWritable.getDeclaredClass();
            }
        }

        @Override
        public void write(DataOutput out) throws IOException {
            UTF8.writeString(out, this.methodName);
            out.writeInt(this.parameterClasses.length);
            for (int i = 0; i < this.parameterClasses.length; ++i) {
                ObjectWritable.writeObject(out, this.parameters[i], this.parameterClasses[i], this.conf);
            }
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer();
            buffer.append(this.methodName);
            buffer.append("(");
            for (int i = 0; i < this.parameters.length; ++i) {
                if (i != 0) {
                    buffer.append(", ");
                }
                buffer.append(this.parameters[i]);
            }
            buffer.append(")");
            return buffer.toString();
        }

        @Override
        public void setConf(Configuration conf) {
            this.conf = conf;
        }

        @Override
        public Configuration getConf() {
            return this.conf;
        }
    }
}

