/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapred.jobcontrol;

import java.io.IOException;
import java.util.ArrayList;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.FileInputFormat;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.JobID;
import org.apache.hadoop.mapred.RunningJob;
import org.apache.hadoop.util.StringUtils;

public class Job {
    public static final int SUCCESS = 0;
    public static final int WAITING = 1;
    public static final int RUNNING = 2;
    public static final int READY = 3;
    public static final int FAILED = 4;
    public static final int DEPENDENT_FAILED = 5;
    private JobConf theJobConf;
    private int state;
    private String jobID;
    private JobID mapredJobID;
    private String jobName;
    private String message;
    private ArrayList<Job> dependingJobs;
    private JobClient jc = null;

    public Job(JobConf jobConf, ArrayList<Job> dependingJobs) throws IOException {
        this.theJobConf = jobConf;
        this.dependingJobs = dependingJobs;
        this.state = 1;
        this.jobID = "unassigned";
        this.mapredJobID = null;
        this.jobName = "unassigned";
        this.message = "just initialized";
        this.jc = new JobClient(jobConf);
    }

    public Job(JobConf jobConf) throws IOException {
        this(jobConf, null);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("job name:\t").append(this.jobName).append("\n");
        sb.append("job id:\t").append(this.jobID).append("\n");
        sb.append("job state:\t").append(this.state).append("\n");
        sb.append("job mapred id:\t").append(this.mapredJobID == null ? "unassigned" : this.mapredJobID).append("\n");
        sb.append("job message:\t").append(this.message).append("\n");
        if (this.dependingJobs == null || this.dependingJobs.size() == 0) {
            sb.append("job has no depending job:\t").append("\n");
        } else {
            sb.append("job has ").append(this.dependingJobs.size()).append(" dependeng jobs:\n");
            for (int i = 0; i < this.dependingJobs.size(); ++i) {
                sb.append("\t depending job ").append(i).append(":\t");
                sb.append(this.dependingJobs.get(i).getJobName()).append("\n");
            }
        }
        return sb.toString();
    }

    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    public String getJobID() {
        return this.jobID;
    }

    public void setJobID(String id) {
        this.jobID = id;
    }

    @Deprecated
    public String getMapredJobID() {
        return this.mapredJobID.toString();
    }

    @Deprecated
    public void setMapredJobID(String mapredJobID) {
        this.mapredJobID = JobID.forName(mapredJobID);
    }

    public JobID getAssignedJobID() {
        return this.mapredJobID;
    }

    public void setAssignedJobID(JobID mapredJobID) {
        this.mapredJobID = mapredJobID;
    }

    public JobConf getJobConf() {
        return this.theJobConf;
    }

    public void setJobConf(JobConf jobConf) {
        this.theJobConf = jobConf;
    }

    public synchronized int getState() {
        return this.state;
    }

    protected synchronized void setState(int state) {
        this.state = state;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public JobClient getJobClient() {
        return this.jc;
    }

    public ArrayList<Job> getDependingJobs() {
        return this.dependingJobs;
    }

    public synchronized boolean addDependingJob(Job dependingJob) {
        if (this.state == 1) {
            if (this.dependingJobs == null) {
                this.dependingJobs = new ArrayList();
            }
            return this.dependingJobs.add(dependingJob);
        }
        return false;
    }

    public boolean isCompleted() {
        return this.state == 4 || this.state == 5 || this.state == 0;
    }

    public boolean isReady() {
        return this.state == 3;
    }

    private void checkRunningState() {
        block12: {
            RunningJob running = null;
            try {
                running = this.jc.getJob(this.mapredJobID);
                if (!running.isComplete()) break block12;
                if (running.isSuccessful()) {
                    this.state = 0;
                    break block12;
                }
                this.state = 4;
                this.message = "Job failed! Error - " + running.getFailureInfo();
                try {
                    running.killJob();
                }
                catch (IOException e1) {
                    // empty catch block
                }
                try {
                    this.jc.close();
                }
                catch (IOException e2) {}
            }
            catch (IOException ioe) {
                this.state = 4;
                this.message = StringUtils.stringifyException(ioe);
                try {
                    if (running != null) {
                        running.killJob();
                    }
                }
                catch (IOException e1) {
                    // empty catch block
                }
                try {
                    this.jc.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }

    synchronized int checkState() {
        int s;
        if (this.state == 2) {
            this.checkRunningState();
        }
        if (this.state != 1) {
            return this.state;
        }
        if (this.dependingJobs == null || this.dependingJobs.size() == 0) {
            this.state = 3;
            return this.state;
        }
        Job pred = null;
        int n = this.dependingJobs.size();
        for (int i = 0; i < n && (s = (pred = this.dependingJobs.get(i)).checkState()) != 1 && s != 3 && s != 2; ++i) {
            if (s == 4 || s == 5) {
                this.state = 5;
                this.message = "depending job " + i + " with jobID " + pred.getJobID() + " failed. " + pred.getMessage();
                break;
            }
            if (i != n - 1) continue;
            this.state = 3;
        }
        return this.state;
    }

    protected synchronized void submit() {
        try {
            if (this.theJobConf.getBoolean("create.empty.dir.if.nonexist", false)) {
                FileSystem fs = FileSystem.get(this.theJobConf);
                Path[] inputPaths = FileInputFormat.getInputPaths(this.theJobConf);
                for (int i = 0; i < inputPaths.length; ++i) {
                    if (fs.exists(inputPaths[i])) continue;
                    try {
                        fs.mkdirs(inputPaths[i]);
                        continue;
                    }
                    catch (IOException e) {
                        // empty catch block
                    }
                }
            }
            RunningJob running = this.jc.submitJob(this.theJobConf);
            this.mapredJobID = running.getID();
            this.state = 2;
        }
        catch (IOException ioe) {
            this.state = 4;
            this.message = StringUtils.stringifyException(ioe);
        }
    }
}

