##############################################################################
# Local Security Check Automation Framework
#
# Authors:
# Veerendra GG <veerendragg@secpod.com>
#
# Revision 1.0
# Date: 2009/04/09
#
# Copyright:
# Copyright (c) 2009 SecPod , http://www.secpod.org
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

import unittest
from parser import mandriva


class MandrivaParserTestCase(unittest.TestCase):

    ## Initial Setup
    mandriva_parser_obj = mandriva.Parser()

    def setUp(self):
        ptr = open('./test/unit_test/work/input/mandriva-2009-03-msg00002.php', 'r')
        lines = ptr.readlines()
        ptr.close

        self.Html_content = "".join(lines)
        setattr(self.mandriva_parser_obj, 'Html_content', self.Html_content)


    def test_getYearLinks(self):
        req_out_put = ['http://lists.mandriva.com/security-announce/2009-01', 'http://lists.mandriva.com/security-announce/2009-02', 'http://lists.mandriva.com/security-announce/2009-03', 'http://lists.mandriva.com/security-announce/2009-04']

        link = './test/unit_test/work/input/mandriva-advisory-main.html'
        year = '2009'
        out_put = self.mandriva_parser_obj._getYearLinks(link, year)
        self.assertEquals(out_put, req_out_put)


    def test_getEachAdvLink(self):
        req_out_put = ['http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00038.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00037.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00036.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00035.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00034.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00033.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00032.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00031.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00030.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00029.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00028.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00027.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00026.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00025.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00024.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00023.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00022.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00021.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00020.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00019.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00018.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00017.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00016.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00015.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00014.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00013.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00012.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00011.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00010.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00009.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00008.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00007.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00006.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00005.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00004.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00003.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00002.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00001.php', 'http://lists.mandriva.com/security-announce/MDVSA-March-2009.html/msg00000.php']

        link = './test/unit_test/work/input/MDVSA-March-2009.html'
        out_put = self.mandriva_parser_obj._getEachAdvLink(link)
        self.assertEquals(out_put, req_out_put)


    def test_getCVE(self):
        print "\nTesting Mandriva Parser Test Suite ..."
        req_out_put = 'CVE-2008-5005'

        out_put = self.mandriva_parser_obj.getCVE()
        self.assertEquals(out_put, req_out_put)


    def test_getAdvID(self):
        req_out_put = 'MDVSA-2009:064'

        out_put = self.mandriva_parser_obj.getAdvID()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedPackage(self):
        req_out_put = 'imap'

        out_put = self.mandriva_parser_obj.getAffectedPackage()
        self.assertEquals(out_put, req_out_put)


    def test_getDescription(self):
        req_out_put = "Security vulnerabilities has been identified and fixed in University\n  of Washington IMAP Toolkit which could allow local users to gain\n  privileges by specifying incorrect folder name (CVE-2008-5005).\n  \n  The updated packages have been patched to prevent this."

        out_put = self.mandriva_parser_obj.getDescription()
        self.assertEquals(out_put, req_out_put)


    def test_getAffectedProduct(self):
        req_out_put = ['Mandriva Linux 2009.0', 'Mandriva Linux 2009.0/X86_64']

        out_put = self.mandriva_parser_obj.getAffectedProduct()
        self.assertEquals(out_put, req_out_put)


    def test_getRPM(self):
        req_out_put = {'MNDK_2009.0': ['imap-2002d-8.4.C30mdk', 'imap-devel-2002d-8.4.C30mdk', 'imap-utils-2002d-8.4.C30mdk']} 

        prod_list = ['Mandriva Linux 2009.0', 'Mandriva Linux 2009.0/X86_64']
        out_put = self.mandriva_parser_obj.getRPM(prod_list)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference1(self):
        req_out_put = 'http://lists.mandriva.com/security-announce/2009-03/msg00002.php'

        main_url = 'http://lists.mandriva.com/security-announce/'
        file_name = '2009-03_msg00002.php'
        out_put = self.mandriva_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_formatReference2(self):
        req_out_put = 'http://lists.mandriva.com/security-announce/2009-03/msg00002.php'

        main_url = 'http://lists.mandriva.com/security-announce'
        file_name = '2009-03_msg00002.php'
        out_put = self.mandriva_parser_obj.formatReference(main_url, file_name)
        self.assertEquals(out_put, req_out_put)


    def test_parser(self):
        req_out_put = True

        prod_list = ['Mandriva Linux 2009.0', 'Mandriva Linux 2009.0/X86_64']
        setattr(self.mandriva_parser_obj, 'Platforms', prod_list)
        out_put = self.mandriva_parser_obj.parser(self.Html_content)
        self.assertEquals(out_put, req_out_put)



if __name__ == '__main__':
    unittest.main()

