# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 103-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(53837);
 script_version ("$");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 103-1 (glibc)";
 script_name(name);

 desc = "The remote host is missing an update to glibc
announced via advisory DSA 103-1.

A buffer overflow has been found in the globbing code for glibc.
This code which is used to glob patterns for filenames and is
commonly used in applications like shells and FTP servers.

This has been fixed in versino 2.1.3-20 and we recommend that
you upgrade your libc package immediately.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20103-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 103-1 (glibc)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"glibc-doc", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"i18ndata", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dbg", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-dev", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-pic", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1-prof", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6.1", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libnss1-compat", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"locales", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"nscd", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dbg", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-dev", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-pic", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6-prof", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libc6", ver:"2.1.3-20", rls:"DEB2.2")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
