# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1798-1 (pango1.0)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(63963);
 script_cve_id("CVE-2009-1194");
 script_version ("$");
 script_tag(name:"cvss_base", value:"6.8");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 1798-1 (pango1.0)";
 script_name(name);

 desc = "The remote host is missing an update to pango1.0
announced via advisory DSA 1798-1.


Will Drewry discovered that pango, a system for layout and rendering of
internationalized text, is prone to an integer overflow via long
glyphstrings. This could cause the execution of arbitrary code when
displaying crafted data through an application using the pango library.


For the stable distribution (lenny), this problem has been fixed in
version 1.20.5-3+lenny1.

For the oldstable distribution (etch), this problem has been fixed in
version 1.14.8-5+etch1.

For the testing distribution (squeeze) and the unstable distribution
(sid), this problem has been fixed in version 1.24-1.


We recommend that you upgrade your pango1.0 packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201798-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 1798-1 (pango1.0)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"libpango1.0-doc", ver:"1.14.8-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-common", ver:"1.14.8-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-0", ver:"1.14.8-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-dev", ver:"1.14.8-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-0-dbg", ver:"1.14.8-5+etch1", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-common", ver:"1.20.5-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-doc", ver:"1.20.5-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-0", ver:"1.20.5-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-0-dbg", ver:"1.20.5-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"libpango1.0-dev", ver:"1.20.5-3+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
