# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 1916-1 (kdelibs)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66100);
 script_cve_id("CVE-2009-2702");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 1916-1 (kdelibs)");

 desc = "The remote host is missing an update to kdelibs
announced via advisory DSA 1916-1.

Dan Kaminsky and Moxie Marlinspike discovered that kdelibs, core libraries from
the official KDE release, does not properly handle a '\0' character in a domain
name in the Subject Alternative Name field of an X.509 certificate, which allows
man-in-the-middle attackers to spoof arbitrary SSL servers via a crafted
certificate issued by a legitimate Certification Authority.


For the oldstable distribution (etch), this problem has been fixed in
version 4:3.5.5a.dfsg.1-8etch3

Due to a bug in the archive system, the fix for the stable distribution
(lenny), will be released as version 4:3.5.10.dfsg.1-0lenny3 once it is
available.

For the testing distribution (squeeze), and the unstable distribution (sid),
this problem has been fixed in version 4:3.5.10.dfsg.1-2.1


We recommend that you upgrade your kdelibs pakcages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%201916-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 1916-1 (kdelibs)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"kdelibs-data", ver:"3.5.5a.dfsg.1-8etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs", ver:"3.5.5a.dfsg.1-8etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-doc", ver:"3.5.5a.dfsg.1-8etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4c2a", ver:"3.5.5a.dfsg.1-8etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs-dbg", ver:"3.5.5a.dfsg.1-8etch3", rls:"DEB4.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"kdelibs4-dev", ver:"3.5.5a.dfsg.1-8etch3", rls:"DEB4.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
