# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 2009-1 (tdiary)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(67033);
 script_cve_id("CVE-2010-0726");
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("Debian Security Advisory DSA 2009-1 (tdiary)");

 desc = "The remote host is missing an update to tdiary
announced via advisory DSA 2009-1.

It was discovered that tdiary, a communication-friendly weblog system,
is prone to a cross-site scripting vulnerability due to insuficient
input sanitising in the TrackBack transmission plugin.


For the stable distribution (lenny), this problem has been fixed in
version 2.2.1-1+lenny1.

For the testing distribution (squeeze), this problem will be fixed soon.

For the unstable distribution (sid), this problem has been fixed in
version 2.2.1-1.1.


We recommend that you upgrade your tdiary packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%202009-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 2009-1 (tdiary)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"tdiary-theme", ver:"2.2.1-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tdiary-contrib", ver:"2.2.1-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tdiary-plugin", ver:"2.2.1-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tdiary-mode", ver:"2.2.1-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"tdiary", ver:"2.2.1-1+lenny1", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
