# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 2013-1 (egroupware)
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(67035);
 script_version ("$Revision$");
 script_tag(name:"risk_factor", value:"High");
 script_name("Debian Security Advisory DSA 2013-1 (egroupware)");

 desc = "The remote host is missing an update to egroupware
announced via advisory DSA 2013-1.

Nahuel Grisolia discovered two vulnerabilities in Egroupware, a web-based
groupware suite: Missing input sanitising in the spellchecker integration
may lead to the execution of arbitrary commands and a cross-site scripting
vulnerability was discovered in the login page.

For the stable distribution (lenny), these problems have been fixed in
version 1.4.004-2.dfsg-4.2.

The upcoming stable distribution (squeeze), no longer contains egroupware
packages.

We recommend that you upgrade your egroupware packages.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%202013-1

Risk factor : High";

 script_description(desc);

 script_summary("Debian Security Advisory DSA 2013-1 (egroupware)");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("Debian Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"egroupware-bookmarks", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-felamimail", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-mydms", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-polls", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-calendar", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-developer-tools", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-etemplate", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-emailadmin", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-phpsysinfo", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-resources", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-news-admin", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-filemanager", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-registration", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-sitemgr", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-phpbrain", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-core", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-infolog", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-tracker", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-wiki", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-sambaadmin", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-addressbook", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-timesheet", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-manual", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"egroupware-projectmanager", ver:"1.4.004-2.dfsg-4.2", rls:"DEB5.0")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
