# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory DSA 997-1
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2007 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largerly excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(56405);
 script_cve_id("CVE-2006-0460");
 script_bugtraq_id(16697);
 script_version ("$");
 script_tag(name:"cvss_base", value:"7.5");
 script_tag(name:"risk_factor", value:"High");
 name = "Debian Security Advisory DSA 997-1 (bomberclone)";
 script_name(name);

 desc = "The remote host is missing an update to bomberclone
announced via advisory DSA 997-1.

Stefan Cornelius of Gentoo Security discovered that bomberclone, a
free Bomberman-like game, crashes when receiving overly long error
packets, which may also allow remote attackers to execute arbitrary
code.

The old stable distribution (woody) does not contain bomberclone packages.

For the stable distribution (sarge) these problems have been fixed in
version 0.11.5-1sarge1.

For the unstable distribution (sid) these problems have been fixed in
version 0.11.6.2-1.

We recommend that you upgrade your bomberclone package.

Solution:
https://secure1.securityspace.com/smysecure/catid.html?in=DSA%20997-1

Risk factor : High";

 script_description(desc);

 summary = "Debian Security Advisory DSA 997-1 (bomberclone)";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2006 E-Soft Inc. http://www.securityspace.com");
 family = "Debian Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/packages");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-deb.inc");
vuln = 0;
if(isdpkgvuln(pkg:"bomberclone-data", ver:"0.11.5-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}
if(isdpkgvuln(pkg:"bomberclone", ver:"0.11.5-1sarge1", rls:"DEB3.1")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
