#
#VID 1ac77649-0908-11dd-974d-000fea2763ce
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(60834);
 script_cve_id("CVE-2008-1531");
 script_bugtraq_id(28489);
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: lighttpd";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: lighttpd

CVE-2008-1531
The connection_state_machine function (connections.c) in lighttpd
1.4.19 and earlier, and 1.5.x before 1.5.0, allows remote attackers to
cause a denial of service (active SSL connection loss) by triggering
an SSL error, such as disconnecting before a download has finished,
which causes all active SSL connections to be lost.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://secunia.com/advisories/29649
http://trac.lighttpd.net/trac/ticket/285
http://www.vuxml.org/freebsd/1ac77649-0908-11dd-974d-000fea2763ce.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: lighttpd";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"lighttpd");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.19_1")<0) {
    security_note(0, data:"Package lighttpd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
