#
#VID 1a3bd81f-1b25-11df-bd1a-002170daae37
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from VID 1a3bd81f-1b25-11df-bd1a-002170daae37
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#

if(description)
{
 script_id(66846);
 script_cve_id("CVE-2010-0295");
 script_bugtraq_id(38036);
 script_version ("$Revision$");
 script_tag(name:"cvss_base", value:"5.0");
 script_tag(name:"risk_factor", value:"Medium");
 script_name("FreeBSD Ports: lighttpd");

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: lighttpd

CVE-2010-0295
lighttpd before 1.4.26, and 1.5.x, allocates a buffer for each read
operation that occurs for a request, which allows remote attackers to
cause a denial of service (memory consumption) by breaking a request
into small pieces that are sent at a slow rate.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://download.lighttpd.net/lighttpd/security/lighttpd_sa_2010_01.txt
http://www.vuxml.org/freebsd/1a3bd81f-1b25-11df-bd1a-002170daae37.html

Risk factor : High";

 script_description(desc);

 script_summary("FreeBSD Ports: lighttpd");

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2010 E-Soft Inc. http://www.securityspace.com");
 script_family("FreeBSD Local Security Checks");
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"lighttpd");
if(!isnull(bver) && revcomp(a:bver, b:"1.4.26")<0) {
    security_note(0, data:"Package lighttpd version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
