#
#VID 7e580822-8cd8-11d9-8c81-000a95bc6fae
# OpenVAS Vulnerability Test
# $
# Description: Auto generated from vuxml or freebsd advisories
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2008 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisories, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
if(description)
{
 script_id(52165);
 script_cve_id("CVE-2005-0616");
 script_version ("$");
 script_tag(name:"cvss_base", value:"4.3");
 script_tag(name:"risk_factor", value:"Medium");
 name = "FreeBSD Ports: postnuke";
 script_name(name);

 desc = "The remote host is missing an update to the system
as announced in the referenced advisory.

The following package is affected: postnuke

CVE-2005-0616
Multiple cross-site scripting (XSS) vulnerabilities in the Download
module for PostNuke 0.750 and 0.760-RC2 allow remote attackers to
inject arbitrary web script or HTML via the (1) Program name, (2) File
link, (3) Author name (4) Author e-mail address, (5) File size, (6)
Version, or (7) Home page variables.

Solution:
Update your system with the appropriate patches or
software upgrades.

http://news.postnuke.com/Article2669.html
http://marc.theaimsgroup.com/?l=bugtraq&m=110962768300373
http://www.vuxml.org/freebsd/7e580822-8cd8-11d9-8c81-000a95bc6fae.html

Risk factor : High";

 script_description(desc);

 summary = "FreeBSD Ports: postnuke";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2005 E-Soft Inc. http://www.securityspace.com");
 family = "FreeBSD Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/freebsdrel");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-bsd.inc");
vuln = 0;
bver = portver(pkg:"postnuke");
if(!isnull(bver) && revcomp(a:bver, b:"0.760")<0) {
    security_note(0, data:"Package postnuke version " + bver + " is installed which is known to be vulnerable.");
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
