###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_apple_safari_uri_dos_vuln_win.nasl 629 2009-03-04 10:40:26Z mar $
#
# Apple Safari URI NULL Pointer Dereference DoS Vulnerability (Win)
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800524);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-0744");
  script_bugtraq_id(33909);
  script_name("Apple Safari URI NULL Pointer Dereference DoS Vulnerability (Win)");
  desc = "

  Overview: This host is running Apple Safari web browser and is prone
  to denial of service vulnerability.

  Vulnerability Insight:
  Browser fails to adequately sanitize user supplied input in URI feeds.
  Hence when certain characters are passed at the begining of the URI,
  the NULL Pointer Dereference bug occurs, using '%', '{', '}', '`', '^', '|'
  and '&' characters.

  Impact:
  Successful exploitation could allow remote attackers to cause browser crash.

  Impact Level: Application

  Affected Software/OS:
  Apple Safari version 4 beta and prior on Windows.

  Fix: No solution or patch is available as on 04th March, 2009. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.apple.com/support/downloads

  References:
  http://xforce.iss.net/xforce/xfdb/48943
  http://www.securityfocus.com/archive/1/archive/1/501229/100/0/threaded

  CVSS Score:
    CVSS Base Score     : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score : 4.5
  Risk factor : Medium";

  script_description(desc);
  script_summary("Check for the version of Apple Safari");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Denial of Service");
  script_dependencies("secpod_apple_safari_detect_win_900003.nasl");
  script_require_keys("AppleSafari/Version");
  exit(0);
}


include("version_func.inc");

safariVer = get_kb_item("AppleSafari/Version");
if(!safariVer){
  exit(0);
}

# Apple Safari Version <= (4.28.16.0) 4 build 528.16
if(version_is_less_equal(version:safariVer, test_version:"4.28.16.0")){
  security_warning(0);
}
