###############################################################################
# OpenVAS Vulnerability Test
#
# Fedora Update for cronie FEDORA-2010-2751
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(861703);
  script_version("$Revision: 8150 $: 1.0");
  script_tag(name:"cvss_base", value:"3.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_xref(name: "FEDORA", value: "2010-2751");
  script_cve_id("CVE-2010-0424");
  script_name("Fedora Update for cronie FEDORA-2010-2751");
  desc = "

  Vulnerability Insight:
  Cronie contains the standard UNIX daemon crond that runs specified programs at
  scheduled times and related tools. It is a fork of the original vixie-cron and
  has security and configuration enhancements like the ability to use pam and
  SELinux.


  Affected Software/OS:
  cronie on Fedora 12

  Fix: Please Install the Updated Packages.

  References:
  http://lists.fedoraproject.org/pipermail/package-announce/2010-February/035762.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of cronie");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Fedora Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "FC12")
{

  if(isrpmvuln(pkg:"cronie", rpm:"cronie~1.4.3~4.fc12", rls:"FC12"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}