###############################################################################
# OpenVAS Vulnerability Test
#
# HP-UX Update for XFree86 HPSBUX01018
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(835157);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "HPSBUX", value: "01018");
  script_cve_id("CAN-2004-0083", "CAN-2004-0084", "CAN-2004-0106");
  script_name( "HP-UX Update for XFree86 HPSBUX01018");
  desc = "

  Vulnerability Insight:
  A potential security vulnerability has been identified with HP-UX, where a 
  bufferoverflow in XFree86 could be remotely exploited to gain unauthorized 
  privileged access or execute arbitrary code. 

  Impact:
  Remote unauthorized privileged access
  execution of arbitrary code.

  Affected Software/OS:
  XFree86 on
  HP-UX B.11.00, B.11.04, B.11.11, B.11.22, and B.11.23 

  Fix: Please Install the Updated Packages.

  References:
  http://www11.itrc.hp.com/service/cki/docDisplay.do?docId=emr_na-c00957781-2

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of XFree86");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("HP-UX Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-hpux.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "HPUX11.22")
{

  if(ishpuxpkgvuln(pkg:"Xserver.OEM-SERVER", patch_list:['PHSS_30172'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"X11.MKFONTDIR", patch_list:['PHSS_30479'], rls:"HPUX11.22"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.23")
{

  if(ishpuxpkgvuln(pkg:"Xserver.OEM-SERVER", patch_list:['PHSS_30171'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"X11.MKFONTDIR", patch_list:['PHSS_30480'], rls:"HPUX11.23"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.04")
{

  if(ishpuxpkgvuln(pkg:"Xserver.X11-SERV", patch_list:['PHSS_30586'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"X11.MKFONTDIR", patch_list:['PHSS_30706'], rls:"HPUX11.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.00")
{

  if(ishpuxpkgvuln(pkg:"Xserver.X11-SERV", patch_list:['PHSS_30181'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"X11.MKFONTDIR", patch_list:['PHSS_30477'], rls:"HPUX11.00"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "HPUX11.11")
{

  if(ishpuxpkgvuln(pkg:"Xserver.X11-SERV", patch_list:['PHSS_30173'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  if(ishpuxpkgvuln(pkg:"X11.MKFONTDIR", patch_list:['PHSS_30478'], rls:"HPUX11.11"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}