###############################################################################
# OpenVAS Vulnerability Test
#
# Mandriva Update for gnome-applets MDVA-2008:091-1 (gnome-applets)
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(830660);
  script_version("$Revision: 1.0 $");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "MDVA", value: "2008:091-1");
  script_name( "Mandriva Update for gnome-applets MDVA-2008:091-1 (gnome-applets)");
  desc = "

  Vulnerability Insight:

  The clock applet in GNOME could crash when using some specific
  locations or when using updated timezone data.  The Recent Documents
  menu was not always able to start the right application for a specific
  document.
  
  Update:
  
  The previous gnome-applets package on x86_64 was improperly built
  and included apm support when it should not have, resulting in an
  extra dependency that could cause installation issues.  This update
  corrects the problem.

  Affected Software/OS:
  gnome-applets on Mandriva Linux 2008.1,
  Mandriva Linux 2008.1/X86_64

  Fix: Please Install the Updated Packages.

  References:
  http://lists.mandriva.com/security-announce/2008-11/msg00007.php

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of gnome-applets");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Mandrake Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-rpm.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "MNDK_2008.1")
{

  if(isrpmvuln(pkg:"gnome-applets", rpm:"gnome-applets~2.22.2~1.2mdv2008.1", rls:"MNDK_2008.1"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}