###############################################################################
# OpenVAS Vulnerability Test
# $Id: gb_pegasus_mail_pop3_bof_vuln.nasl 5592 2009-11-05 14:00:02Z nov $
#
# Pegasus Mail POP3 Response Buffer Overflow Vulnerability
#
# Authors:
# Nikita MR <rnikita@secpod.com>
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(800970);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"10.0");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2009-3838");
  script_bugtraq_id(36797);
  script_name("Pegasus Mail POP3 Response Buffer Overflow Vulnerability");
  desc = "
  Overview: This host is running Pegasus Mail which is prone to stack-based
  Buffer Overflow vulnerability.

  Vulnerability Insight:
  A stack based buffer overflow error occus due to improper bounds checking
  when processing POP3 responses.

  Impact:
  Successful exploitation will allow attackers to execute arbitrary code or
  cause the application to crash by sending overly long error responses from
  a remote POP3 server to the affected mail client.

  Impact Level: Application

  Affected Software/OS:
  Pegasus Mail 4.51 and prior.

  Fix:
  No solution or patch is available as on 05th November, 2009.Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.pmail.com/downloads_s3_t.htm

  References:
  http://secunia.com/advisories/37134
  http://www.vupen.com/english/advisories/2009/3026
  http://securitytracker.com/alerts/2009/Oct/1023075.html

  CVSS Score:
    CVSS Base Score     : 10.0 (AV:N/AC:L/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 9.0
  Risk factor: Critical";

  script_description(desc);
  script_summary("Check for the version of Pegasus Mail");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Greenbone Networks GmbH");
  script_family("Buffer overflow");
  script_dependencies("gb_pegasus_mail_detect.nasl");
  script_require_keys("Pegasus/Mail/Ver");
  exit(0);
}


include("version_func.inc");

pmailVer = get_kb_item("Pegasus/Mail/Ver");
if(isnull(pmailVer)){
  exit(0);
}

# Check for version 4.51 (4.5.1.0) and prior.
if(version_is_less_equal(version:pmailVer, test_version:"4.5.1.0")){
  security_hole(0);
}
