###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for firefox vulnerabilities USN-592-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2009 Intevation GmbH, http://www.intevation.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840285);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_xref(name: "USN", value: "592-1");
  script_cve_id("CVE-2007-4879", "CVE-2008-0416", "CVE-2008-1195", "CVE-2008-1233", "CVE-2008-1234", "CVE-2008-1235", "CVE-2008-1236", "CVE-2008-1237", "CVE-2008-1238", "CVE-2008-1240", "CVE-2008-1241");
  script_name( "Ubuntu Update for firefox vulnerabilities USN-592-1");
  desc = "

  Vulnerability Insight:

  Alexey Proskuryakov, Yosuke Hasegawa and Simon Montagu discovered flaws
  in Firefox's character encoding handling. If a user were tricked into
  opening a malicious web page, an attacker could perform cross-site
  scripting attacks. (CVE-2008-0416)
  
  Various flaws were discovered in the JavaScript engine. By tricking
  a user into opening a malicious web page, an attacker could escalate
  privileges within the browser, perform cross-site scripting attacks
  and/or execute arbitrary code with the user's privileges.
  (CVE-2008-1233, CVE-2008-1234, CVE-2008-1235)
  
  Several problems were discovered in Firefox which could lead to crashes
  and memory corruption. If a user were tricked into opening a malicious
  web page, an attacker may be able to execute arbitrary code with the
  user's privileges. (CVE-2008-1236, CVE-2008-1237)
  
  Gregory Fleischer discovered Firefox did not properly process HTTP
  Referrer headers when they were sent with with requests to URLs
  containing Basic Authentication credentials with empty usernames. An
  attacker could exploit this vulnerability to perform cross-site request
  forgery attacks. (CVE-2008-1238)
  
  Peter Brodersen and Alexander Klink reported that default the setting in
  Firefox for SSL Client Authentication allowed for users to be tracked
  via their client certificate. The default has been changed to prompt
  the user each time a website requests a client certificate.
  (CVE-2007-4879)
  
  Gregory Fleischer discovered that web content fetched via the jar
  protocol could use Java LiveConnect to connect to arbitrary ports on
  the user's machine due to improper parsing in the Java plugin. If a
  user were tricked into opening malicious web content, an attacker may be
  able to access services running on the user's machine. (CVE-2008-1195,
  CVE-2008-1240)
  
  Chris Thomas discovered that Firefox would allow an XUL popup from an
  unselected tab to display in front of the selected tab. An attacker
  could exploit this behavior to spoof a login prompt and steal the user's
  credentials. (CVE-2008-1241)

  Affected Software/OS:
  firefox vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 6.10 ,
  Ubuntu 7.04 ,
  Ubuntu 7.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2008-March/000681.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of firefox vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 Intevation GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU7.04")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.13+0nobinonly-0ubuntu0.7.4", rls:"UBUNTU7.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"1.5.dfsg+1.5.0.15~prepatch080323a-0ubuntu1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.10")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr-dev", ver:"1.firefox2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnspr4", ver:"1.firefox2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss-dev", ver:"1.firefox2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"libnss3", ver:"1.firefox2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dev", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-dom-inspector", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox-gnome-support", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"mozilla-firefox", ver:"2.0.0.13+0nobinonly-0ubuntu0.6.10", rls:"UBUNTU6.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU7.10")
{

  if(isdpkgvuln(pkg:"firefox-dbg", ver:"2.0.0.13+1nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dev", ver:"2.0.0.13+1nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-gnome-support", ver:"2.0.0.13+1nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-libthai", ver:"2.0.0.13+1nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox", ver:"2.0.0.13+1nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  if(isdpkgvuln(pkg:"firefox-dom-inspector", ver:"2.0.0.13+1nobinonly-0ubuntu0.7.10", rls:"UBUNTU7.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}