###############################################################################
# OpenVAS Vulnerability Test
#
# Ubuntu Update for lintian vulnerabilities USN-891-1
#
# Authors:
# System Generated Check
#
# Copyright:
# Copyright (c) 2010 Greenbone Networks GmbH, http://www.greenbone.net
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(840382);
  script_version("$Revision: 7480 $: 1.0");
  script_tag(name:"cvss_base", value:"7.5");
  script_tag(name:"risk_factor", value:"High");
  script_xref(name: "USN", value: "891-1");
  script_cve_id("CVE-2009-4013", "CVE-2009-4014", "CVE-2009-4015");
  script_name("Ubuntu Update for lintian vulnerabilities USN-891-1");
  desc = "

  Vulnerability Insight:

  It was discovered that lintian did not correctly validate certain
  filenames when processing input.  If a user or an automated system
  were tricked into running lintian on a specially crafted set of files,
  a remote attacker could execute arbitrary code with user privileges.

  Affected Software/OS:
  lintian vulnerabilities on Ubuntu 6.06 LTS ,
  Ubuntu 8.04 LTS ,
  Ubuntu 8.10 ,
  Ubuntu 9.04 ,
  Ubuntu 9.10

  Fix: Please Install the Updated Packages.

  References:
  https://lists.ubuntu.com/archives/ubuntu-security-announce/2010-January/001038.html

  Risk factor: High";

  script_description(desc);
  script_summary("Check for the Version of lintian vulnerabilities");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (c) 2010 Greenbone Networks GmbH");
  script_family("Ubuntu Local Security Checks");
  script_dependencies("gather-package-list.nasl");
  script_require_keys("ssh/login/release");
  exit(0);
}


include("pkg-lib-deb.inc");
include("revisions-lib.inc");

release = get_kb_item("ssh/login/release");

if(release == NULL){
  exit(0);
}

if(release == "UBUNTU9.04")
{

  if(isdpkgvuln(pkg:"lintian", ver:"2.2.5ubuntu1.1", rls:"UBUNTU9.04"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU6.06 LTS")
{

  if(isdpkgvuln(pkg:"lintian", ver:"1.23.16ubuntu2.1", rls:"UBUNTU6.06 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.10")
{

  if(isdpkgvuln(pkg:"lintian", ver:"1.24.3ubuntu0.1", rls:"UBUNTU8.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU8.04 LTS")
{

  if(isdpkgvuln(pkg:"lintian", ver:"1.23.46ubuntu0.1", rls:"UBUNTU8.04 LTS"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}


if(release == "UBUNTU9.10")
{

  if(isdpkgvuln(pkg:"lintian", ver:"2.2.17ubuntu1.1", rls:"UBUNTU9.10"))
  {
    security_hole(0);
    exit(0);
  }

  exit(0);
}