##############################################################################
# This script was written by David Maciejak <david dot maciejak at kyxar dot fr>
# based on work from
# (C) Tenable Network Security
#
# Ref: Jakob Balle
#
# Updated: 03/12/2009 Antu Sanadi <santu@secpod.com>
#
# This script is released under the GNU GPLv2
###############################################################################

if(description)
{
  script_id(14244);
  script_cve_id("CVE-2004-2260");
  script_bugtraq_id(10337);
  script_version("$Revision: 8287 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_name("Opera web browser address bar spoofing weakness");
  desc = "
  The remote host is using Opera - an alternative web browser.

  This version of Opera is vulnerable to a security weakness
  that may permit malicious web pages to spoof address bar information.

  This is reportedly possible through malicious use of the
  JavaScript 'unOnload' event handler when the browser
  is redirected to another page.

  This issue could be exploited to spoof the domain of a malicious web page,
  potentially causing the victim user to trust the spoofed domain.

  Solution : Install Opera 7.50 or newer.

  Risk factor : High";

  script_description(desc);
  script_summary("Determines the version of Opera.exe");
  script_category(ACT_GATHER_INFO);
  script_copyright("This script is Copyright (C) 2004 David Maciejak");
  script_family("Windows");
  script_dependencies("secpod_opera_detection_win_900036.nasl");
  script_require_keys("Opera/Win/Version");
  exit(0);
}


include("version_func.inc");

OperaVer = get_kb_item("Opera/Win/Version");
if(!OperaVer){
  exit(0);
}

if(version_is_less_equal(version:OperaVer, test_version:"7.49")){
  security_hole(0);
}
