###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_gupnp_dos_vuln.nasl 3104 2009-06-01 15:05:27Z may $
#
# GUPnP Message Handling Denial Of Service Vulnerability
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900682);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"5.0");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2009-2174");
  script_bugtraq_id(35390);
  script_name("GUPnP Message Handling Denial Of Service Vulnerability");
  desc = "

  Overview: This host has installed GUPnP is prone to Denial Of Service
  Vulnerability

  Vulnerability Insight:
  The flaw is caused due to an error when processing subscription or control
  messages with an empty content.

  Impact:
  Successful exploitation via specially crafted messages will allow attackers to
  run arbitrary code, crash the application and cause cause denial of service.

  Impact Level: System/Application

  Affected Software/OS:
  GUPnP Version 0.12.7 and prior.

  Fix:Upgrade to version 0.12.8 or later.
  http://www.gupnp.org/sources/

  References:
  http://www.osvdb.org/55128
  http://secunia.com/advisories/35482
  http://www.vupen.com/english/advisories/2009/1597

  CVSS Score:
    CVSS Base Score      : 5.0 (AV:N/AC:L/Au:NR/C:N/I:N/A:P)
    CVSS Temporal Score  : 3.9
  Risk factor: Medium";

  script_description(desc);
  script_summary("Checks for the Version of GUPnP");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("Denial of Service");
  script_dependencies("secpod_gupnp_detect.nasl");
  script_require_keys("GUPnP/Ver");
  exit(0);
}


include("version_func.inc");

gupnpVer = get_kb_item("GUPnP/Ver");
if(gupnpVer != NULL)
{
  if(version_is_less(version:gupnpVer, test_version:"0.12.8")){
    security_warning(0);
  }
}
