###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_info_disc_vuln_feb10.nasl 7336 2010-02-19 12:33:29 feb $
#
# Microsoft Internet Explorer Information Disclosure Vulnerability Feb10
#
# Authors:
# Rachana Shetty <srachana@secpod.com>
#
# Copyright:
# Copyright (c) 2010 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900741);
  script_version("$Revision: 7619 $: 1.0");
  script_tag(name:"cvss_base", value:"4.3");
  script_tag(name:"risk_factor", value:"Medium");
  script_cve_id("CVE-2010-0652");
  script_name("Microsoft Internet Explorer Information Disclosure Vulnerability Feb10");
  desc = "
  Overview: This host has Internet Explorer installed and is prone to Information
  Disclosure vulnerability.

  Vulnerability Insight:
  The flaw exists while handling malformed stylesheet document with incorrect
  MIME type. Microsoft Internet Explorer permits cross-origin loading of CSS
  stylesheets even when the stylesheet download has an incorrect MIME type.

  Impact:
  Successful exploitation allows attackers to obtain sensitive information via
  a crafted stylesheet document.

  Impact Level: Application.

  Affected Software/OS:
  Microsoft Internet Explorer version 8 and prior on Windows

  Fix: No solution or patch is available as on 19th February, 2010. Information
  regarding this issue will be updated once the solution details are available.
  For updates refer, http://www.microsoft.com/windows/products/default.aspx

  References:
  http://code.google.com/p/chromium/issues/detail?id=9877

  CVSS Score:
    CVSS Base Score      : 4.3 (AV:N/AC:M/Au:NR/C:P/I:N/A:N)
    CVSS Temporal Score  : 3.7
  Risk factor: Medium";

  script_description(desc);
  script_summary("Check for the version of Internet Explorer");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2010 SecPod");
  script_family("General");
  script_dependencies("gb_ms_ie_detect.nasl");
  script_require_keys("MS/IE/Version");
  exit(0);
}


include("version_func.inc");

ieVer = get_kb_item("MS/IE/Version");
if(isnull(ieVer)){
  exit(0);
}

## Check for IE version less or equal 8.0.6001.18702
if(version_is_less_equal(version:ieVer, test_version:"8.0.6001.18702")){
  security_warning(0);
}

