###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_ms_ie_mem_crptn_vuln.nasl 658 2008-12-12 09:50:55Z dec $
#
# Vulnerability in Internet Explorer Could Allow Remote Code Execution (960714)
#
# Authors:
# Chandan S <schandan@secpod.com>
#
# Copyright: SecPod
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################


if(description)
{
  script_id(900066);
  script_version("$Revision: 1.0 $");
  script_tag(name:"cvss_base", value:"9.3");
  script_tag(name:"risk_factor", value:"Critical");
  script_cve_id("CVE-2008-4844");
  script_bugtraq_id(32721);
  script_name("Vulnerability in Internet Explorer Could Allow Remote Code Execution (960714)");
  desc = "

  Overview: This host has critical security update missing according to
  Microsoft Bulletin MS08-078.

  Vulnerability Insight:
  The flaw is caused due to a use-after-free error when HTML elements
  are bound to the same data source.

  Impact:
  Successful exploitation could result in memory corruption via a specially
  crafted HTML document.

  Impact Level: Application

  Affected Software/OS:
  Internet Explorer 5.01 & 6 on MS Windows 2000
  Internet Explorer 6 on MS Windows 2003 and XP
  Internet Explorer 7 on MS Windows 2003 and XP

  Fix:
  Run Windows Update and update the listed hotfixes or download and
  update mentioned hotfixes in the advisory from the below link,
  http://www.microsoft.com/technet/security/bulletin/ms08-078.mspx

  References:
  http://www.microsoft.com/technet/security/bulletin/ms08-078.mspx

  CVSS Score:
    CVSS Base Score     : 9.3 (AV:N/AC:M/Au:NR/C:C/I:C/A:C)
    CVSS Temporal Score : 8.0
  Risk factor : High";

  script_description(desc);
  script_summary("Check for the vulnerable File Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2008 SecPod");
  script_family("Windows : Microsoft Bulletins");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_reg.inc");
include("version_func.inc");
include("secpod_smb_func.inc");

if(hotfix_check_sp(xp:4, win2k:5, win2003:3) <= 0){
  exit(0);
}

ieVer = registry_get_sz(key:"SOFTWARE\Microsoft\Internet Explorer",
                        item:"Version");
if(!ieVer){
  ieVer = registry_get_sz(item:"IE",
          key:"SOFTWARE\Microsoft\Internet Explorer\Version Vector");
}

if(!ieVer){
  exit(0);
}

# MS08-078 Hotfix (960714)
if(hotfix_missing(name:"960714") == 0){
  exit(0);
}

dllPath = registry_get_sz(item:"Install Path",
                          key:"SOFTWARE\Microsoft\COM3\Setup");
dllPath += "\mshtml.dll";

share = ereg_replace(pattern:"([A-Z]):.*", replace:"\1$", string:dllPath);
file =  ereg_replace(pattern:"[A-Z]:(.*)", replace:"\1", string:dllPath);

vers = GetVer(file:file, share:share);
if(!vers){
  exit(0);
}

if(hotfix_check_sp(win2k:5, xp:4) > 0)
{
  # Check for IE version 5 < 5.0.3872.1000
  if(version_in_range(version:vers, test_version:"5.0",
                      test_version2:"5.0.3872.999")){
    security_hole(0);
  }
  # Check for IE version 6 < 6.0.2800.1619
  else if(version_in_range(version:vers, test_version:"6.0",
                           test_version2:"6.0.2800.1618")){
    security_hole(0);
  }
}

if(hotfix_check_sp(xp:4) > 0)
{
  SP = get_kb_item("SMB/WinXP/ServicePack");
  if("Service Pack 2" >< SP)
  {
    # Check for IE version 6 < 6.0.2900.3492
    if(version_in_range(version:vers, test_version:"6.0.2900",
                        test_version2:"6.0.2900.3491")){
      security_hole(0);
    }
  }
  else if("Service Pack 3" >< SP)
  {
    # Check for IE version 6 < 6.0.2900.5726
    if(version_in_range(version:vers, test_version:"6.0.2900",
                        test_version2:"6.0.2900.5725")){
      security_hole(0);
    }
  }
  else security_hole(0);

  # Check for IE version 7 < 7.0.6000.16788
  if(version_in_range(version:vers, test_version:"7.0",
                      test_version2:"7.0.6000.16787")){
      security_hole(0);
  }
}

if(hotfix_check_sp(win2003:3) > 0)
{
  SP = get_kb_item("SMB/Win2003/ServicePack");
  if("Service Pack 1" >< SP)
  {
    # Check for IE version 6 < 6.0.3790.3261
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.3790.3260")){
      security_hole(0);
    }
  }
  else if("Service Pack 2" >< SP)
  {
    # Check for IE version 6 < 6.0.3790.4426
    if(version_in_range(version:vers, test_version:"6.0",
                        test_version2:"6.0.3790.4425")){
      security_hole(0);
    }
  }
  else security_hole(0);

  # Check for IE version 7 < 7.0.6000.16788
  if(version_in_range(version:vers, test_version:"7.0",
                      test_version2:"7.0.6000.16787")){
      security_hole(0);
  }
}
