###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_squid_detect.nasl 1089 2009-03-17 20:05:29Z Feb $
#
# Squid Version Detection
#
# Authors:
# Antu Sanadi <santu@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
################################################################################

if(description)
{
  script_id(900611);
  script_version ("$Revision: 1.2 $");
  script_tag(name:"risk_factor", value:"None");
  script_name("Squid Version Detection");
  desc = "
  Overview: This scripts determines the  version of squid server and
  sets the value in KB.

  Risk factor:None";

  script_description(desc);
  script_summary("Sets KB of Squid Version");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod.");
  script_family("Service detection");
  script_dependencie("find_service.nes");
  script_require_ports("Services/www", 3128, 8080);
  exit(0);
}


include("http_func.inc");

port = get_kb_item("Services/http_proxy");
if(!port){
  port = 3128;
}

if(!get_port_state(port)){
  port = 8080;
}

if(!get_port_state(port)){
  exit(0);
}

soc = http_open_socket(port);
if(!soc){
  exit(0);
}

req = http_get(item:"http://www.$$$$$", port:port);
send(socket:soc, data:req);

res = http_recv(socket:soc);
http_close_socket(soc);

data = egrep(pattern:"^Server: squid", string:res);
version = data - "Server: squid/" - '\r\n';
if(version){
  set_kb_item(name:"www/" + port + "/Squid", value:version);
  security_note(data:"Squid version " + version + " was detected on the host");
}
