###############################################################################
# OpenVAS Vulnerability Test
# $Id: secpod_tvp_detect.nasl 896 2009-01-28 12:30:24Z jan $
#
# Total Video Player Version Detection
#
# Authors:
# Sujit Ghosal <sghosal@secpod.com>
#
# Copyright:
# Copyright (c) 2009 SecPod, http://www.secpod.com
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if(description)
{
  script_id(900453);
  script_version("Revision: 1.0 ");
  script_tag(name:"risk_factor", value:"None");
  script_name("Total Video Player Version Detection");
  desc = "
  Overview: This script detects the installed version of Total Video Player
  and sets the result in KB.

  Risk factor: None";

  script_description(desc);
  script_summary("Sets the KB for the version of Total Video Player");
  script_category(ACT_GATHER_INFO);
  script_copyright("Copyright (C) 2009 SecPod");
  script_family("General");
  script_dependencies("secpod_reg_enum.nasl");
  script_require_keys("SMB/WindowsVersion");
  script_require_ports(139, 445);
  exit(0);
}


include("smb_nt.inc");
include("secpod_smb_func.inc");

if(!get_kb_item("SMB/WindowsVersion")){
  exit(0);
}

if(!registry_key_exists(key:"SOFTWARE\iTinySoft\Total Video Player")){
  exit(0);
}

key = "SOFTWARE\Microsoft\Windows\CurrentVersion\Uninstall\";
entries = registry_enum_keys(key:key);
foreach item (entries)
{
  name = registry_get_sz(key:key + item, item:"DisplayName");
  if("Total Video Player" >< name)
  {
    tvpVer = eregmatch(pattern:"Total Video Player ([0-9.]+)", string:name);
    if(tvpVer[1] != NULL){
      set_kb_item(name:"TotalVideo/Player/Ver", value:tvpVer[1]);
      security_note(data:"Total Video Player version " + tvpVer[1] +
                         " was detected on the host");
    }
    exit(0);
  }
}
