# OpenVAS Vulnerability Test
# $Id$
# Description: Auto-generated from advisory SUSE-SR:2009:007
#
# Authors:
# Thomas Reinke <reinke@securityspace.com>
#
# Copyright:
# Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com
# Text descriptions are largely excerpted from the referenced
# advisory, and are Copyright (c) the respective author(s)
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2,
# or at your option, GNU General Public License version 3,
# as published by the Free Software Foundation
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
#
                                                                                
if(description)
{
 script_id(63687);
 script_cve_id("CVE-2007-6018", "CVE-2008-2364", "CVE-2008-2712", "CVE-2008-3074", "CVE-2008-3075", "CVE-2008-3076", "CVE-2008-4677", "CVE-2008-5917", "CVE-2008-6235", "CVE-2009-0115", "CVE-2009-0499", "CVE-2009-0500", "CVE-2009-0501", "CVE-2009-0502", "CVE-2009-0581", "CVE-2009-0583", "CVE-2009-0584", "CVE-2009-0723", "CVE-2009-0733", "CVE-2009-0914", "CVE-2009-0915", "CVE-2009-0916", "CVE-2009-0930", "CVE-2009-0932");
 script_version ("$");
 script_tag(name:"cvss_base", value:"10.0");
 script_tag(name:"risk_factor", value:"Critical");
 name = "SuSE Security Summary SUSE-SR:2009:007";
 script_name(name);

 desc = "The remote host is missing updates announced in
advisory SUSE-SR:2009:007.  SuSE Security Summaries are short
on detail when it comes to the names of packages affected by
a particular bug. Because of this, while this test will detect
out of date packages, it cannot tell you what bugs impact
which packages, or vice versa.

Solution:

Update all out of date packages.

Risk factor : High";

 script_description(desc);

 summary = "SuSE Security Advisory SUSE-SR:2009:007";
 script_summary(summary);

 script_category(ACT_GATHER_INFO);

 script_copyright("Copyright (c) 2009 E-Soft Inc. http://www.securityspace.com");
 family = "SuSE Local Security Checks";
 script_family(family);
 script_dependencies("gather-package-list.nasl");
 script_require_keys("ssh/login/rpms");
 exit(0);
}

#
# The script code starts here
#

include("revisions-lib.inc");
include("pkg-lib-rpm.inc");
vuln = 0;
if(isrpmvuln(pkg:"ConsoleKit", rpm:"ConsoleKit~0.2.10~60.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ConsoleKit-devel", rpm:"ConsoleKit-devel~0.2.10~60.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ConsoleKit-x11", rpm:"ConsoleKit-x11~0.2.10~60.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"Mesa", rpm:"Mesa~7.2~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"Mesa-devel", rpm:"Mesa-devel~7.2~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"Mesa-devel-static", rpm:"Mesa-devel-static~7.2~10.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ModemManager", rpm:"ModemManager~0.1_20081203~6.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.7~1.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-branding-upstream", rpm:"MozillaFirefox-branding-upstream~3.0.7~1.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.7~1.1.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.7.0.r4359~15.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-devel", rpm:"NetworkManager-devel~0.7.0.r4359~15.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-doc", rpm:"NetworkManager-doc~0.7.0.r4359~15.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-glib", rpm:"NetworkManager-glib~0.7.0.r4359~15.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-gnome", rpm:"NetworkManager-gnome~0.7.0.r1053~11.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-kde", rpm:"NetworkManager-kde~0.7r848570~23.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-kde-devel", rpm:"NetworkManager-kde-devel~0.7r848570~23.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-openvpn-kde", rpm:"NetworkManager-openvpn-kde~0.7r848570~23.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-vpnc-kde", rpm:"NetworkManager-vpnc-kde~0.7r848570~23.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acroread", rpm:"acroread~8.1.4~0.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"blt", rpm:"blt~2.4z~342.62.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"cifs-mount", rpm:"cifs-mount~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1", rpm:"dbus-1~1.2.10~5.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel", rpm:"dbus-1-devel~1.2.10~5.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel-doc", rpm:"dbus-1-devel-doc~1.2.10~5.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib", rpm:"dbus-1-glib~0.76~32.33.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib-devel", rpm:"dbus-1-glib-devel~0.76~32.33.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib-doc", rpm:"dbus-1-glib-doc~0.76~32.33.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-mono", rpm:"dbus-1-mono~0.63~118.117.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-python", rpm:"dbus-1-python~0.83.0~22.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-python-devel", rpm:"dbus-1-python-devel~0.83.0~22.22.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-qt3", rpm:"dbus-1-qt3~0.62~221.222.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-qt3-devel", rpm:"dbus-1-qt3-devel~0.62~221.222.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-x11", rpm:"dbus-1-x11~1.2.10~5.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freeglut", rpm:"freeglut~080721~20.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"freeglut-devel", rpm:"freeglut-devel~080721~20.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.62~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.62~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.62~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.62~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-ijs-devel", rpm:"ghostscript-ijs-devel~8.62~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.62~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.62~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.62~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-control-center", rpm:"gnome-control-center~2.24.0.1~3.20.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-control-center-devel", rpm:"gnome-control-center-devel~2.24.0.1~3.20.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-control-center-lang", rpm:"gnome-control-center-lang~2.24.0.1~3.20.9", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-desktop", rpm:"gnome-desktop~2.24.1~2.17.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-desktop-devel", rpm:"gnome-desktop-devel~2.24.1~2.17.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-desktop-doc", rpm:"gnome-desktop-doc~2.24.1~2.17.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-desktop-lang", rpm:"gnome-desktop-lang~2.24.1~2.17.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-settings-daemon", rpm:"gnome-settings-daemon~2.24.0~3.20.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-settings-daemon-devel", rpm:"gnome-settings-daemon-devel~2.24.0~3.20.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-settings-daemon-lang", rpm:"gnome-settings-daemon-lang~2.24.0~3.20.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-system-monitor", rpm:"gnome-system-monitor~2.24.1~1.27.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-system-monitor-lang", rpm:"gnome-system-monitor-lang~2.24.1~1.27.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-utils", rpm:"gnome-utils~2.24.1~3.16.8", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-utils-devel", rpm:"gnome-utils-devel~2.24.1~3.16.8", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-utils-doc", rpm:"gnome-utils-doc~2.24.1~3.16.8", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"gnome-utils-lang", rpm:"gnome-utils-lang~2.24.1~3.16.8", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk", rpm:"java-1_6_0-openjdk~1.4_b14~24.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-demo", rpm:"java-1_6_0-openjdk-demo~1.4_b14~24.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-devel", rpm:"java-1_6_0-openjdk-devel~1.4_b14~24.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-javadoc", rpm:"java-1_6_0-openjdk-javadoc~1.4_b14~24.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-plugin", rpm:"java-1_6_0-openjdk-plugin~1.4_b14~24.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-src", rpm:"java-1_6_0-openjdk-src~1.4_b14~24.3.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kpartx", rpm:"kpartx~0.4.8~26.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lcms", rpm:"lcms~1.17~44.59.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ldapsmb", rpm:"ldapsmb~1.34b~6.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~31.40.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgnome-desktop-2-7", rpm:"libgnome-desktop-2-7~2.24.1~2.17.6", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"liblcms-devel", rpm:"liblcms-devel~1.17~44.59.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"liblcms1", rpm:"liblcms1~1.17~44.59.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnetapi-devel", rpm:"libnetapi-devel~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libnetapi0", rpm:"libnetapi0~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.5.1~3.9.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient-devel", rpm:"libsmbclient-devel~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbclient0", rpm:"libsmbclient0~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbsharemodes-devel", rpm:"libsmbsharemodes-devel~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libsmbsharemodes0", rpm:"libsmbsharemodes0~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtalloc-devel", rpm:"libtalloc-devel~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtalloc1", rpm:"libtalloc1~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtdb-devel", rpm:"libtdb-devel~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libtdb1", rpm:"libtdb1~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwbclient-devel", rpm:"libwbclient-devel~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libwbclient0", rpm:"libwbclient0~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mdadm", rpm:"mdadm~3.0~10.9.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.7~1.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.7~1.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.7~1.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.7~1.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"multipath-tools", rpm:"multipath-tools~0.4.8~26.10.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opera", rpm:"opera~9.64~1.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"psmisc", rpm:"psmisc~22.6~61.27.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-lcms", rpm:"python-lcms~1.17~44.59.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"python-xpcom190", rpm:"python-xpcom190~1.9.0.7~1.2.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba", rpm:"samba~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-client", rpm:"samba-client~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-devel", rpm:"samba-devel~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-krb-printing", rpm:"samba-krb-printing~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-vscan", rpm:"samba-vscan~0.3.6b~6.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"samba-winbind", rpm:"samba-winbind~3.2.7~11.2.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sax2", rpm:"sax2~8.1~542.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sax2-gui", rpm:"sax2-gui~8.1~542.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sax2-ident", rpm:"sax2-ident~8.1~542.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sax2-libsax", rpm:"sax2-libsax~8.1~542.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sax2-libsax-devel", rpm:"sax2-libsax-devel~8.1~542.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sax2-libsax-perl", rpm:"sax2-libsax-perl~8.1~542.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sax2-libsax-python", rpm:"sax2-libsax-python~8.1~542.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sax2-tools", rpm:"sax2-tools~8.1~542.8.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"stardict", rpm:"stardict~3.0.1~59.39.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"sysvinit", rpm:"sysvinit~2.86~186.17.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"telepathy-gabble", rpm:"telepathy-gabble~0.7.10~1.21.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"timezone", rpm:"timezone~2009b~3.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomboy", rpm:"tomboy~0.12.1~2.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"tomboy-lang", rpm:"tomboy-lang~0.12.1~2.26.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-input-wacom", rpm:"x11-input-wacom~0.8.1~36.18.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-input-wacom-devel", rpm:"x11-input-wacom-devel~0.8.1~36.18.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"x11-input-wacom-tools", rpm:"x11-input-wacom-tools~0.8.1~36.18.2", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-Xvnc", rpm:"xorg-x11-Xvnc~7.4~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-input", rpm:"xorg-x11-driver-input~7.4~11.6.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-video", rpm:"xorg-x11-driver-video~7.4~19.5.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-driver-video-radeonhd", rpm:"xorg-x11-driver-video-radeonhd~1.2.4_121202_4e89726~2.1.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-server", rpm:"xorg-x11-server~7.4~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-server-extra", rpm:"xorg-x11-server-extra~7.4~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xorg-x11-server-sdk", rpm:"xorg-x11-server-sdk~7.4~17.4.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~97.77.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~97.77.1", rls:"openSUSE11.1")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ConsoleKit", rpm:"ConsoleKit~0.2.10~14.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ConsoleKit-devel", rpm:"ConsoleKit-devel~0.2.10~14.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ConsoleKit-x11", rpm:"ConsoleKit-x11~0.2.10~14.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox", rpm:"MozillaFirefox~3.0.7~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"MozillaFirefox-translations", rpm:"MozillaFirefox-translations~3.0.7~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.7.0.r3685~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-devel", rpm:"NetworkManager-devel~0.7.0.r3685~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-glib", rpm:"NetworkManager-glib~0.7.0.r3685~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-gnome", rpm:"NetworkManager-gnome~0.7.0.r729~7.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-kde", rpm:"NetworkManager-kde~0.7r821737~0.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-kde-devel", rpm:"NetworkManager-kde-devel~0.7r821737~0.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-openvpn-kde", rpm:"NetworkManager-openvpn-kde~0.7r821737~0.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-vpnc-kde", rpm:"NetworkManager-vpnc-kde~0.7r821737~0.5", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acroread", rpm:"acroread~8.1.4~0.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-audio", rpm:"bluez-audio~3.32~8.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-cups", rpm:"bluez-cups~3.32~8.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-test", rpm:"bluez-test~3.32~8.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-utils", rpm:"bluez-utils~3.32~8.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1", rpm:"dbus-1~1.2.1~15.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel", rpm:"dbus-1-devel~1.2.1~15.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel-doc", rpm:"dbus-1-devel-doc~1.2.1~15.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib", rpm:"dbus-1-glib~0.74~88.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib-devel", rpm:"dbus-1-glib-devel~0.74~88.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib-doc", rpm:"dbus-1-glib-doc~0.74~88.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-mono", rpm:"dbus-1-mono~0.63~154.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-python", rpm:"dbus-1-python~0.82.4~49.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-python-devel", rpm:"dbus-1-python-devel~0.82.4~49.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-qt3", rpm:"dbus-1-qt3~0.62~179.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-qt3-devel", rpm:"dbus-1-qt3-devel~0.62~179.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-x11", rpm:"dbus-1-x11~1.2.1~18.4", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-devel", rpm:"ghostscript-devel~8.62~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.62~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.62~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.62~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-ijs-devel", rpm:"ghostscript-ijs-devel~8.62~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.62~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.62~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.62~17.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk", rpm:"java-1_6_0-openjdk~1.4_b14~24.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-demo", rpm:"java-1_6_0-openjdk-demo~1.4_b14~24.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-devel", rpm:"java-1_6_0-openjdk-devel~1.4_b14~24.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-javadoc", rpm:"java-1_6_0-openjdk-javadoc~1.4_b14~24.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-plugin", rpm:"java-1_6_0-openjdk-plugin~1.4_b14~24.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"java-1_6_0-openjdk-src", rpm:"java-1_6_0-openjdk-src~1.4_b14~24.3", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kpartx", rpm:"kpartx~0.4.7~127.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"lcms", rpm:"lcms~1.17~40.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~258.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~258.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"liblcms-devel", rpm:"liblcms-devel~1.17~40.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"liblcms1", rpm:"liblcms1~1.17~40.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.4.1~28.6", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190", rpm:"mozilla-xulrunner190~1.9.0.7~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-devel", rpm:"mozilla-xulrunner190-devel~1.9.0.7~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-gnomevfs", rpm:"mozilla-xulrunner190-gnomevfs~1.9.0.7~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"mozilla-xulrunner190-translations", rpm:"mozilla-xulrunner190-translations~1.9.0.7~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"multipath-tools", rpm:"multipath-tools~0.4.7~127.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opera", rpm:"opera~9.64~1.1", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powersave", rpm:"powersave~0.15.20~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powersave-devel", rpm:"powersave-devel~0.15.20~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powersave-libs", rpm:"powersave-libs~0.15.20~38.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~95.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~95.2", rls:"openSUSE11.0")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager", rpm:"NetworkManager~0.6.5~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-devel", rpm:"NetworkManager-devel~0.6.5~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-glib", rpm:"NetworkManager-glib~0.6.5~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-gnome", rpm:"NetworkManager-gnome~0.6.5~37.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-kde", rpm:"NetworkManager-kde~0.2r674918~55.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-kde-devel", rpm:"NetworkManager-kde-devel~0.2r674918~55.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-openvpn-kde", rpm:"NetworkManager-openvpn-kde~0.2r674918~55.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"NetworkManager-vpnc-kde", rpm:"NetworkManager-vpnc-kde~0.2r674918~55.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"acroread", rpm:"acroread~8.1.4~0.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-cups", rpm:"bluez-cups~3.18~13.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-test", rpm:"bluez-test~3.18~13.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"bluez-utils", rpm:"bluez-utils~3.18~13.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1", rpm:"dbus-1~1.0.2~59.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel", rpm:"dbus-1-devel~1.0.2~59.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-devel-doc", rpm:"dbus-1-devel-doc~1.0.2~59.8", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib", rpm:"dbus-1-glib~0.74~25.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib-devel", rpm:"dbus-1-glib-devel~0.74~25.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-glib-doc", rpm:"dbus-1-glib-doc~0.74~25.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-mono", rpm:"dbus-1-mono~0.63~90.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-python", rpm:"dbus-1-python~0.82.0~28.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-python-devel", rpm:"dbus-1-python-devel~0.82.0~28.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-qt3", rpm:"dbus-1-qt3~0.62~110.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-qt3-devel", rpm:"dbus-1-qt3-devel~0.62~110.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"dbus-1-x11", rpm:"dbus-1-x11~1.0.2~67.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-other", rpm:"ghostscript-fonts-other~8.15.4~3.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-rus", rpm:"ghostscript-fonts-rus~8.15.4~3.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-fonts-std", rpm:"ghostscript-fonts-std~8.15.4~3.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-ijs-devel", rpm:"ghostscript-ijs-devel~8.15.4~3.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-library", rpm:"ghostscript-library~8.15.4~3.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-omni", rpm:"ghostscript-omni~8.15.4~3.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"ghostscript-x11", rpm:"ghostscript-x11~8.15.4~3.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal", rpm:"hal~0.5.9_git20070831~13.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"hal-devel", rpm:"hal-devel~0.5.9_git20070831~13.7", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"kpartx", rpm:"kpartx~0.4.7~80.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint", rpm:"libgimpprint~4.2.7~178.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libgimpprint-devel", rpm:"libgimpprint-devel~4.2.7~178.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"liblcms", rpm:"liblcms~1.16~39.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"liblcms-devel", rpm:"liblcms-devel~1.16~39.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"libpurple", rpm:"libpurple~2.3.1~26.4", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"multipath-tools", rpm:"multipath-tools~0.4.7~80.2", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"opera", rpm:"opera~9.64~1.1", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powersave", rpm:"powersave~0.15.17~10.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powersave-devel", rpm:"powersave-devel~0.15.17~10.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"powersave-libs", rpm:"powersave-libs~0.15.17~10.3", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf", rpm:"xpdf~3.02~19.6", rls:"openSUSE10.3")) {
    vuln = 1;
}
if(isrpmvuln(pkg:"xpdf-tools", rpm:"xpdf-tools~3.02~19.6", rls:"openSUSE10.3")) {
    vuln = 1;
}

if(vuln) {
    security_hole(0);
}
