###############################################################################
# OpenVAS Vulnerability Test
# $Id: tftgallery_36833.nasl 7591 2010-05-07 14:40:46Z chandra $
#
# TFTgallery 'album' Parameter Cross Site Scripting Vulnerability
#
# Authors:
# Michael Meyer
#
# Copyright:
# Copyright (c) 2009 Greenbone Networks GmbH
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License version 2
# (or any later version), as published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
###############################################################################

if (description)
{
 script_id(100325);
 script_bugtraq_id(36833);
 script_version ("1.0-$Revision: 7591 $");
 script_tag(name:"risk_factor", value:"Low");

 script_name("TFTgallery 'album' Parameter Cross Site Scripting Vulnerability");

desc = "Overview:
TFTgallery is prone to a cross-site scripting vulnerability because
the application fails to sufficiently sanitize user-supplied input.

An attacker may leverage this issue to execute arbitrary script code
in the browser of an unsuspecting user in the context of the affected
site. This may let the attacker steal cookie-based authentication
credentials and launch other attacks.

This issue affects TFTgallery 0.13; other versions may be
vulnerable as well.

References:
http://www.securityfocus.com/bid/36833
http://www.tftgallery.org/

Risk factor : Low";

 script_description(desc);
 script_summary("Determine if TFTgallery version is 0.13");
 script_category(ACT_GATHER_INFO);
 script_family("Web application abuses");
 script_copyright("This script is Copyright (C) 2009 Greenbone Networks GmbH");
 script_dependencies("tftgallery_detect.nasl");
 script_require_ports("Services/www", 80);
 script_exclude_keys("Settings/disable_cgi_scanning");
 exit(0);
}

include("http_func.inc");
include("version_func.inc");

port = get_http_port(default:80);
if(!get_port_state(port))exit(0);

if (!can_host_php(port:port)) exit(0);

if(!version = get_kb_item(string("www/", port, "/tftgallery")))exit(0);
if(!matches = eregmatch(string:version, pattern:"^(.+) under (/.*)$"))exit(0);

vers = matches[1];

if(!isnull(vers) && vers >!< "unknown") {

  if(version_is_equal(version: vers, test_version: "0.13")) {
      security_warning(port:port);
      exit(0);
  }

}

exit(0);
