use Test2::V0;
use Test2::Tools::Command;

use FindBin qw($Bin);

plan 5;

local @Test2::Tools::Command::command = ( $ENV{'SDML'} || 'sdml' );

subtest 'options or arguments' => sub {
	command {
		stderr => qr{\n\QUsage: sdml [OPTIONS] <COMMAND>},
		status => 2,
	};
};

subtest 'help option' => sub {
	command {
		args   => ['--help'],
		stdout => qr{\n\QUsage: sdml [OPTIONS] <COMMAND>},
	};
};

subtest 'version option' => sub {
	command {
		args   => ['--version'],
		stdout => qr{^sdml-cli},
	};
};

subtest 'concept diagram, native' => sub {
	command {
		args  => [qw(draw --diagram concepts --input), "examples/example.sdm"],
		stdout => qr{\Q[label="Example"]},
	};
};

subtest 'concept diagram, SVG' => sub {
	command {
		args  => [qw(draw --diagram concepts --output-format svg --input), "examples/example.sdm"],
		stdout => qr{\Q<title>Example</title>},
	};
};

done_testing;
