systemd Secure boot integration
===============================
sicher*boot automatically installs systemd-boot and kernels for it into the
[ESP][], signed with keys generated by it.

 [ESP]: https://en.wikipedia.org/wiki/EFI_System_partition

[![Run Status](https://api.shippable.com/projects/57d313eea0e0fc1000037262/badge?branch=master)](https://app.shippable.com/projects/57d313eea0e0fc1000037262)


SECURITY
--------
The signing keys are stored unencrypted and only protected by the file system
permissions. Thus, you should make sure that the file system they are
stored (usually `/etc`) in is encrypted.

Setup
------------
After installing sicherboot, you can adjust a number of settings in
`/etc/sicherboot.conf` and should set a kernel commandline in
`/etc/kernel/cmdline`.

Then run

  sicherboot setup

to get started.

Limitations
-----------
* Kernels and initramfs images must be named `/boot/vmlinuz-<ver>` and
  `/boot/initrd.img-<ver>`
* Only a single ESP is supported.


Integrating with your package management
----------------------------------------
You want to run:

* `sicherboot bootctl update`
  - whenever systemd is upgraded or installed
* `sicherboot install-kernel <ver>`
  - when the kernel is installed and the initramfs was built
* `sicherboot remove-kernel <ver>`
  - when the kernel shall be removed

As an example, kernel and initramfs contain integration with `/etc/kernel`
and initramfs-tools. Install one of the kernel postinst`.d` scripts - the dracut
one exists for dracut systems as a work around for dracut not supporting hooks.
