/* Public domain. */

#ifndef DJBUNIX_H
#define DJBUNIX_H

#include "gccattributes.h"
#include "stralloc.h"
#include "envalloc.h"
#include "env.h"        /* compatibility */

extern int coe (int) ;
extern int uncoe (int) ;
extern void deepsleep (unsigned int) gccattr_const ;
extern int fd_copy (int, int) ;
extern int fd_copy2 (int, int, int, int) ;
extern int fd_move (int, int) ;
extern int fd_move2 (int, int, int, int) ;
extern int fd_close (int) ;
extern int fifo_make (char const *, unsigned int) ;
extern int lock_ex (int) ;
extern int lock_exnb (int) ;
extern int lock_sh (int) ;
extern int lock_shnb (int) ;
extern int lock_un (int) ;
extern int ndelay_on (int) ;
extern int ndelay_off (int) ;
extern int open2 (char const *, unsigned int) ;
extern int open3 (char const *, unsigned int, unsigned int) ;
extern int open_read (char const *) ;
extern int open_readb (char const *) ;
extern int open_excl (char const *) ;
extern int open_append (char const *) ;
extern int open_trunc (char const *) ;
extern int open_write (char const *) ;

extern int pathexec_env (char const *, char const *) ;
extern void pathexec_r (char const *const *, char const *const *, unsigned int, char const *, unsigned int) ;
extern void pathexec_r_tmp (char const *const *, char const *const *, unsigned int, char const *, unsigned int, stralloc *) ;
extern void pathexec_r_tmp_envtmp (char const *const *, char const *const *, unsigned int, char const *, unsigned int, stralloc *, envalloc *) ;
extern void pathexec_fromenv (char const *const *, char const *const *, unsigned int) ;
extern void pathexec_fromenv_tmp (char const *const *, char const *const *, unsigned int, stralloc *) ;
extern void execvep (char const *, char const *const *, char const *const *, char const *) ;
extern void execvep_tmp (char const *, char const *const *, char const *const *, char const *, stralloc *) ;
extern void pathexec_run (char const *, char const *const *, char const *const *) ;
extern void pathexec_run_tmp (char const *, char const *const *, char const *const *, stralloc *) ;
extern void pathexec0_run (char const *const *, char const *const *) ;
extern void pathexec0_run_tmp (char const *const *, char const *const *, stralloc *) ;
extern void pathexec (char const *const *) ;
extern void pathexec_tmp (char const *const *, stralloc *) ;
extern void pathexec0 (char const *const *) ;
extern void pathexec0_tmp (char const *const *, stralloc *) ;

extern int prot_gid (int) ;
extern int prot_uid (int) ;

extern long seek_cur (int) ;
extern int seek_set (int, long) ;
extern int seek_end (int) ;
extern int seek_trunc (int, long) ;
#define seek_begin(fd) (seek_set((fd), 0))

extern int wait_pid (int *, int) ;
extern int wait_nohang (int *) ;
extern int wait_pid_nohang (int *, int) ;
extern int wait_pids_nohang (int *, int const *, unsigned int) ;
extern int wait_stop (void) ;
extern int wait_stopnohang (void) ;

#define wait_crashed(w) ((w) & 127)
#define wait_exitcode(w) ((w) >> 8)
#define wait_stopsig(w) ((w) >> 8)
#define wait_stopped(w) (((w) & 127) == 127)
#define wait_status(w) (wait_crashed(w) ? 111 : wait_exitcode(w))

extern int fd_chdir (int) ;

#define absolutepath(sa, s) sarealpath(sa, s)
extern char *realpath (char const *, char *) ; /* SUSv3 */
extern char *realpath_tmp (char const *, char *, stralloc *) ;
extern int sarealpath (stralloc *, char const *) ;
extern int sarealpath_tmp (stralloc *, char const *, stralloc *) ;
extern char *basename (char *) ; /* SUSv3 */
extern int sabasename (stralloc *, char const *, unsigned int) ;
extern char *dirname (char *) ; /* SUSv3 */
extern int sadirname (stralloc *, char const *, unsigned int) ;
extern int sagetcwd (stralloc *) ;
extern int sareadlink (stralloc *, char const *) ;
extern int sagethostname (stralloc *) ;

extern int doublefork (void) ;
extern unsigned int wait_reap (void) ;
extern int waitn (int const *, unsigned int) ;

extern int slurp (stralloc *, int) ;
extern int openslurpclose (stralloc *, char const *) ;
extern int openreadclose (char const *, stralloc *, unsigned int) ;
extern int openreadnclose (char const *, char *, unsigned int) ;

extern int rm_rf (char const *) ;
extern int rm_rf_tmp (char const *, stralloc *) ;
extern int rm_rf_in_tmp (stralloc *, unsigned int) ; /* caution ! */
extern int rmstar (char const *) ;
extern int rmstar_tmp (char const *, stralloc *) ;

#endif
