#!/bin/bash

TEMP=`mktemp -d`

if [ ! -x /usr/bin/hg ]; then
	echo "Please install mercurial";
	exit 1;
fi

if [ -d "$1" ]; then
	cp -r $1 $TEMP/snakeyaml/
else
	hg clone https://code.google.com/p/snakeyaml/ $TEMP/snakeyaml
fi

cd $TEMP/snakeyaml;
LATEST_VERSION='0.0'
for VER in $( hg tags |grep '^v[0-9]\.[0-9]* ' |sed 's/^v//' |awk '{print $1}'); do 
	if dpkg --compare-versions "$VER" ge "$LATEST_VERSION" ; then
		LATEST_VERSION=$VER
	fi 
done
hg update "v$LATEST_VERSION" >/dev/null
hg archive --exclude '\.hg*' --type tgz --prefix "." "$TEMP/snakeyaml_$LATEST_VERSION.orig.tar.gz"
cd - 
mv "$TEMP/snakeyaml_$LATEST_VERSION.orig.tar.gz" ../

rm -r $TEMP
