/******************************************************************************
*       SOFA, Simulation Open-Framework Architecture, version 1.0 beta 4      *
*                (c) 2006-2009 MGH, INRIA, USTL, UJF, CNRS                    *
*                                                                             *
* This library is free software; you can redistribute it and/or modify it     *
* under the terms of the GNU Lesser General Public License as published by    *
* the Free Software Foundation; either version 2.1 of the License, or (at     *
* your option) any later version.                                             *
*                                                                             *
* This library is distributed in the hope that it will be useful, but WITHOUT *
* ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or       *
* FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public License *
* for more details.                                                           *
*                                                                             *
* You should have received a copy of the GNU Lesser General Public License    *
* along with this library; if not, write to the Free Software Foundation,     *
* Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301 USA.          *
*******************************************************************************
*                               SOFA :: Modules                               *
*                                                                             *
* Authors: The SOFA Team and external contributors (see Authors.txt)          *
*                                                                             *
* Contact information: contact@sofa-framework.org                             *
******************************************************************************/
#include <sofa/component/topology/Hexa2TetraTopologicalMapping.h>

#include <sofa/core/ObjectFactory.h>

#include <sofa/component/topology/HexahedronSetTopologyContainer.h>
#include <sofa/component/topology/HexahedronSetTopologyModifier.h>
#include <sofa/component/topology/HexahedronSetTopologyChange.h>

#include <sofa/component/topology/TetrahedronSetTopologyContainer.h>
#include <sofa/component/topology/TetrahedronSetTopologyModifier.h>
#include <sofa/component/topology/TetrahedronSetTopologyChange.h>

#include <sofa/component/topology/PointSetTopologyChange.h> 
#include <sofa/component/topology/GridTopology.h>

#include <sofa/defaulttype/Vec.h>
#include <map>
#include <sofa/defaulttype/VecTypes.h>

namespace sofa
{

namespace component
{

namespace topology
{

using namespace sofa::defaulttype;

using namespace sofa::component::topology;
using namespace sofa::core::componentmodel::topology;

SOFA_DECL_CLASS(Hexa2TetraTopologicalMapping)

// Register in the Factory
int Hexa2TetraTopologicalMappingClass = core::RegisterObject("Special case of mapping where HexahedronSetTopology is converted to TetrahedronSetTopology")
.add< Hexa2TetraTopologicalMapping >()

;

// Implementation

Hexa2TetraTopologicalMapping::Hexa2TetraTopologicalMapping(In* from, Out* to)
: TopologicalMapping(from, to),
object1(initData(&object1, std::string("../.."), "object1", "First object to map")),
object2(initData(&object2, std::string(".."), "object2", "Second object to map"))
{
}

Hexa2TetraTopologicalMapping::~Hexa2TetraTopologicalMapping()
{
}

void Hexa2TetraTopologicalMapping::init()
{
	//sout << "INFO_print : init Hexa2TetraTopologicalMapping" << sendl;

	// INITIALISATION of TETRAHEDRAL mesh from HEXAHEDRAL mesh :

	if (fromModel) {
		
		sout << "INFO_print : Hexa2TetraTopologicalMapping - from = hexa" << sendl;
		
		if (toModel) {

			sout << "INFO_print : Hexa2TetraTopologicalMapping - to = tetra" << sendl;

			TetrahedronSetTopologyContainer *to_tstc;
		    toModel->getContext()->get(to_tstc);	
			to_tstc->clear();

			toModel->setNbPoints(fromModel->getNbPoints());

			TetrahedronSetTopologyModifier *to_tstm;
		    toModel->getContext()->get(to_tstm);	

			Loc2GlobVec.clear();
			Glob2LocMap.clear();			

#ifdef SOFA_NEW_HEXA
			int nbcubes = fromModel->getNbHexas();
#else
			int nbcubes = fromModel->getNbCubes();
#endif
			// These values are only correct if the mesh is a grid topology
			int nx = 2;
			int ny = 1;
			int nz = 1;
			{
				topology::GridTopology* grid = dynamic_cast<topology::GridTopology*>(fromModel);
				if (grid != NULL)
				{
					nx = grid->getNx()-1;
					ny = grid->getNy()-1;
					nz = grid->getNz()-1;
				}
			}
	
			// Tesselation of each cube into 6 tetrahedra
			for (int i=0;i<nbcubes;i++)
			{
#ifdef SOFA_NEW_HEXA			
				core::componentmodel::topology::BaseMeshTopology::Hexa c = fromModel->getHexa(i);
#define swap(a,b) { int t = a; a = b; b = t; }
				// TODO : swap indexes where needed (currently crash in TriangleSetContainer)
// 				if (!((i%nx)&1))
// 				{ // swap all points on the X edges
// 					swap(c[0],c[1]);
// 					swap(c[3],c[2]);
// 					swap(c[4],c[5]);
// 					swap(c[7],c[6]);
// 				}
// 				if (((i/nx)%ny)&1)
// 				{ // swap all points on the Y edges
// 					swap(c[0],c[3]);
// 					swap(c[1],c[2]);
// 					swap(c[4],c[7]);
// 					swap(c[5],c[6]);
// 				}
// 				if ((i/(nx*ny))&1)
// 				{ // swap all points on the Z edges
// 					swap(c[0],c[4]);
// 					swap(c[1],c[5]);
// 					swap(c[2],c[6]);
// 					swap(c[3],c[7]);
// 				}
#undef swap
				typedef core::componentmodel::topology::BaseMeshTopology::Tetra Tetra;
				to_tstm->addTetrahedronProcess(Tetra(c[0],c[5],c[1],c[6]));
				to_tstm->addTetrahedronProcess(Tetra(c[0],c[1],c[3],c[6]));
				to_tstm->addTetrahedronProcess(Tetra(c[1],c[3],c[6],c[2]));
				to_tstm->addTetrahedronProcess(Tetra(c[6],c[3],c[0],c[7]));
				to_tstm->addTetrahedronProcess(Tetra(c[6],c[7],c[0],c[5]));
				to_tstm->addTetrahedronProcess(Tetra(c[7],c[5],c[4],c[0]));
#else
				core::componentmodel::topology::BaseMeshTopology::Cube c = fromModel->getCube(i);
				int sym = 0;
				if (!((i%nx)&1)) sym+=1;
				if (((i/nx)%ny)&1) sym+=2;
				if ((i/(nx*ny))&1) sym+=4;
				typedef core::componentmodel::topology::BaseMeshTopology::Tetra Tetra;
				to_tstm->addTetrahedronProcess(Tetra(c[0^sym],c[5^sym],c[1^sym],c[7^sym]));
				to_tstm->addTetrahedronProcess(Tetra(c[0^sym],c[1^sym],c[2^sym],c[7^sym]));
				to_tstm->addTetrahedronProcess(Tetra(c[1^sym],c[2^sym],c[7^sym],c[3^sym]));
				to_tstm->addTetrahedronProcess(Tetra(c[7^sym],c[2^sym],c[0^sym],c[6^sym]));
				to_tstm->addTetrahedronProcess(Tetra(c[7^sym],c[6^sym],c[0^sym],c[5^sym]));
				to_tstm->addTetrahedronProcess(Tetra(c[6^sym],c[5^sym],c[4^sym],c[0^sym]));
#endif		
				for(int j=0; j<6; j++)
					Loc2GlobVec.push_back(i);
				Glob2LocMap[i]=Loc2GlobVec.size()-1;
			}
			
			//to_tstm->propagateTopologicalChanges();
			to_tstm->notifyEndingEvent();
			//to_tstm->propagateTopologicalChanges();

		}

	}
}

unsigned int Hexa2TetraTopologicalMapping::getFromIndex(unsigned int /*ind*/){
	
	return 0;	
}

void Hexa2TetraTopologicalMapping::updateTopologicalMappingTopDown(){
// TODO...
}


} // namespace topology

} // namespace component

} // namespace sofa
