8.3 Escalas

# Escalas

Sonic Pi incluye un gran rango de escalas. ¿qué tal tocar una escala de
Do3 mayor?

```
play_pattern_timed scale(:c3, :major), 0.125, release: 0.1
```

Podemos pedir para más octavas:

```
play_pattern_timed scale(:c3, :major, num_octaves: 3), 0.125, release: 0.1
```

¿qué tal todas las notas de la escala pentatónica?

```
play_pattern_timed scale(:c3, :major_pentatonic, num_octaves: 3), 0.125, release: 0.1
```

## Notas al Azar

Los Acordes y Escalas son una buena manera de restringir una elección 
aleatoria para hacer algo significativo. Toca esl siguiente ejemplo que
agarra notas al azar del acorde de E3 menor:


```
use_synth :tb303
loop do
  play choose(chord(:E3, :minor)), release: 0.3, cutoff: rrand(60, 120)
  sleep 0.25
end
```

Intenta cambiar los nombres de acordes y los rangos de corte.

## Descubriendo Acordes y Escalas

Para saber cuáles acordes y escalas vienen con Sonic Pi, simplemente
cliquea el botón Lang a la izquierda de este tutorial y elige acorde o
escala de la lista API. En la información en el panel principal, baja
hasta ver una larga lista de acordes y escalas (dependiendo de cuál estés
viendo).


¡Diviértete y siempre recuerda que no hay errores, sólo oportunidades!
