6.2 FX en la práctica

# FX en la práctica

Aunque a simple vista sean simples, los FX son - internamente - unas
bestias complejas. Su simplicidad a veces promueve a que la gente los
sobre use en su música. Esto no es un problema si tienes una máquina
poderosa, pero si - como yo - usas una Raspberry Pi para tus jams,
debes ser cuidadoso acerca de cuanto trabajo le asignas para asegurarte
que todo fluya sin pausas.

Considera este código:

```
loop do
  with_fx :reverb do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

En este código estamos tocando la nota 60 con un tiempo de release muy,
corto, por lo que es una nota muy corta. También queríamos reverb, así 
que lo envolvimos en un bloque de reverberación. Todo bien, excepto...

Veamos lo que hace el código. Primero bucleamos para que se repita por
siempre todo lo que está dentro de él. Después tenemos un bloque `with_fx`
Esto significa que crearemos un FX reverberación *cada vez que buclee*.
Esto es como tener un pedal de reverberación por cada vez que toques una
cuerda de la guitarra. Es bueno poder hacerlo, pero no siempre lo querrás.
Por ejemplo, este código tendrá dificultades en una Raspberry Pi. Todo el
trabajo de crear la reverberación y después esperar hasta que ncesite ser
parado y removido, es hecho por `with_fx` pero esto consume mucho del CPU.

¿cómo lo haríamos más similar a cuando un guitarrista tiene sólo *un*
pedal de reverberación a través del cual pasan todos los sonidos?
Simple:

```
with_fx :reverb do
  loop do
    play 60, release: 0.1
    sleep 0.125
  end
end
```

Poniendo nuestro bucle *dentro* del bloque `with_fx`. Así sólo creamos
un paso a reverb para todas las notas del bucle. Este código es mucho 
más eficiente y funcionará bien en una Raspberry Pi.

Al utilizar `with_fx` sobre una iteración en un bucle:

```
loop do
  with_fx :reverb do
    16.times do
      play 60, release: 0.1
      sleep 0.125
    end
  end
end
```

Sacando el `with_fx` de la parte interna del bucle, ahora la reverberación
es cada 16 notas.

Recuerda que no hay errores, sólo posibilidades. Sin embargo, según qué
manera, se producen diferentes sonidos y características de ejecución.
Así que experimenta y utiliza lo que te suene mejor y funcione en la 
plataforma que tengas.
