/*

 helper function for srs_init.c -- populating the SPATIAL_REF_SYS table

 this code was autogenerated by "auto_epsg_ext" on Thu Mar  3 12:51:49 2022

 Author: Sandro Furieri a.furieri@lqt.it

 -----------------------------------------------------------------------------

 Version: MPL 1.1/GPL 2.0/LGPL 2.1

 The contents of this file are subject to the Mozilla Public License Version
 1.1 (the "License"); you may not use this file except in compliance with
 the License. You may obtain a copy of the License at
 http://www.mozilla.org/MPL/

Software distributed under the License is distributed on an "AS IS" basis,
WITHOUT WARRANTY OF ANY KIND, either express or implied. See the License
for the specific language governing rights and limitations under the
License.

The Original Code is the SpatiaLite library

The Initial Developer of the Original Code is Alessandro Furieri

Portions created by the Initial Developer are Copyright (C) 2008
the Initial Developer. All Rights Reserved.

Contributor(s):

Alternatively, the contents of this file may be used under the terms of
either the GNU General Public License Version 2 or later (the "GPL"), or
the GNU Lesser General Public License Version 2.1 or later (the "LGPL"),
in which case the provisions of the GPL or the LGPL are applicable instead
of those above. If you wish to allow use of your version of this file only
under the terms of either the GPL or the LGPL, and not to allow others to
use your version of this file under the terms of the MPL, indicate your
decision by deleting the provisions above and replace them with the notice
and other provisions required by the GPL or the LGPL. If you do not delete
the provisions above, a recipient may use your version of this file under
the terms of any one of the MPL, the GPL or the LGPL.

*/

#if defined(_WIN32) && !defined(__MINGW32__)
#include "config-msvc.h"
#else
#include "config.h"
#endif

#include <spatialite_private.h>

#ifndef OMIT_EPSG    /* full EPSG initialization enabled */

SPATIALITE_PRIVATE void
initialize_epsg_50 (int filter, struct epsg_defs **first, struct epsg_defs **last)
{
/* initializing the EPSG defs list */
    struct epsg_defs *p;
    p = add_epsg_def_ex (filter, first, last, 21218, "epsg", 21218,
        "GSK-2011 / GSK 3GK zone 18", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=18250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 18\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",54],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",18250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21218\"]]");
    p = add_epsg_def_ex (filter, first, last, 21219, "epsg", 21219,
        "GSK-2011 / GSK 3GK zone 19", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=19250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 19\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",57],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",19250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21219\"]]");
    p = add_epsg_def_ex (filter, first, last, 21220, "epsg", 21220,
        "GSK-2011 / GSK 3GK zone 20", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=20250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 20\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",60],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",20250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21220\"]]");
    p = add_epsg_def_ex (filter, first, last, 21221, "epsg", 21221,
        "GSK-2011 / GSK 3GK zone 21", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=21250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 21\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",63],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",21250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21221\"]]");
    p = add_epsg_def_ex (filter, first, last, 21222, "epsg", 21222,
        "GSK-2011 / GSK 3GK zone 22", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=22250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 22\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",66],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",22250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21222\"]]");
    p = add_epsg_def_ex (filter, first, last, 21223, "epsg", 21223,
        "GSK-2011 / GSK 3GK zone 23", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=23250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 23\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",69],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",23250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21223\"]]");
    p = add_epsg_def_ex (filter, first, last, 21224, "epsg", 21224,
        "GSK-2011 / GSK 3GK zone 24", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=24250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 24\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",72],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",24250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21224\"]]");
    p = add_epsg_def_ex (filter, first, last, 21225, "epsg", 21225,
        "GSK-2011 / GSK 3GK zone 25", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=25250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 25\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",75],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",25250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21225\"]]");
    p = add_epsg_def_ex (filter, first, last, 21226, "epsg", 21226,
        "GSK-2011 / GSK 3GK zone 26", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=26250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 26\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",78],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",26250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21226\"]]");
    p = add_epsg_def_ex (filter, first, last, 21227, "epsg", 21227,
        "GSK-2011 / GSK 3GK zone 27", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=27250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 27\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",81],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",27250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21227\"]]");
    p = add_epsg_def_ex (filter, first, last, 21228, "epsg", 21228,
        "GSK-2011 / GSK 3GK zone 28", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=28250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 28\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",84],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",28250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21228\"]]");
    p = add_epsg_def_ex (filter, first, last, 21229, "epsg", 21229,
        "GSK-2011 / GSK 3GK zone 29", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=29250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 29\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",87],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",29250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21229\"]]");
    p = add_epsg_def_ex (filter, first, last, 21230, "epsg", 21230,
        "GSK-2011 / GSK 3GK zone 30", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=30250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 30\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",90],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",30250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21230\"]]");
    p = add_epsg_def_ex (filter, first, last, 21231, "epsg", 21231,
        "GSK-2011 / GSK 3GK zone 31", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=31250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 31\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",93],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",31250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21231\"]]");
    p = add_epsg_def_ex (filter, first, last, 21232, "epsg", 21232,
        "GSK-2011 / GSK 3GK zone 32", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=32250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 32\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",96],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",32250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21232\"]]");
    p = add_epsg_def_ex (filter, first, last, 21233, "epsg", 21233,
        "GSK-2011 / GSK 3GK zone 33", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=33250000 +y_0=0");
    add_proj4text (p, 1,
        " +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 33\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",33250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21233\"]]");
    p = add_epsg_def_ex (filter, first, last, 21234, "epsg", 21234,
        "GSK-2011 / GSK 3GK zone 34", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=34250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 34\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",102],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",34250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21234\"]]");
    p = add_epsg_def_ex (filter, first, last, 21235, "epsg", 21235,
        "GSK-2011 / GSK 3GK zone 35", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=35250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 35\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",35250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21235\"]]");
    p = add_epsg_def_ex (filter, first, last, 21236, "epsg", 21236,
        "GSK-2011 / GSK 3GK zone 36", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=36250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 36\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",108],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",36250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21236\"]]");
    p = add_epsg_def_ex (filter, first, last, 21237, "epsg", 21237,
        "GSK-2011 / GSK 3GK zone 37", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=37250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 37\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",37250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21237\"]]");
    p = add_epsg_def_ex (filter, first, last, 21238, "epsg", 21238,
        "GSK-2011 / GSK 3GK zone 38", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=38250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 38\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",114],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",38250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21238\"]]");
    p = add_epsg_def_ex (filter, first, last, 21239, "epsg", 21239,
        "GSK-2011 / GSK 3GK zone 39", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=39250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 39\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",39250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21239\"]]");
    p = add_epsg_def_ex (filter, first, last, 21240, "epsg", 21240,
        "GSK-2011 / GSK 3GK zone 40", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=40250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 40\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",120],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",40250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21240\"]]");
    p = add_epsg_def_ex (filter, first, last, 21241, "epsg", 21241,
        "GSK-2011 / GSK 3GK zone 41", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=41250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 41\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",41250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21241\"]]");
    p = add_epsg_def_ex (filter, first, last, 21242, "epsg", 21242,
        "GSK-2011 / GSK 3GK zone 42", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=42250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 42\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",126],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",42250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21242\"]]");
    p = add_epsg_def_ex (filter, first, last, 21243, "epsg", 21243,
        "GSK-2011 / GSK 3GK zone 43", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=43250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 43\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",43250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21243\"]]");
    p = add_epsg_def_ex (filter, first, last, 21244, "epsg", 21244,
        "GSK-2011 / GSK 3GK zone 44", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=44250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 44\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",132],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",44250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21244\"]]");
    p = add_epsg_def_ex (filter, first, last, 21245, "epsg", 21245,
        "GSK-2011 / GSK 3GK zone 45", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=45250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 45\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",135],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",45250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21245\"]]");
    p = add_epsg_def_ex (filter, first, last, 21246, "epsg", 21246,
        "GSK-2011 / GSK 3GK zone 46", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=46250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 46\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",138],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",46250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21246\"]]");
    p = add_epsg_def_ex (filter, first, last, 21247, "epsg", 21247,
        "GSK-2011 / GSK 3GK zone 47", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=47250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 47\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",141],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",47250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21247\"]]");
    p = add_epsg_def_ex (filter, first, last, 21248, "epsg", 21248,
        "GSK-2011 / GSK 3GK zone 48", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=48250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 48\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",144],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",48250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21248\"]]");
    p = add_epsg_def_ex (filter, first, last, 21249, "epsg", 21249,
        "GSK-2011 / GSK 3GK zone 49", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=49250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 49\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",147],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",49250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21249\"]]");
    p = add_epsg_def_ex (filter, first, last, 21250, "epsg", 21250,
        "GSK-2011 / GSK 3GK zone 50", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=50250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 50\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",150],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",50250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21250\"]]");
    p = add_epsg_def_ex (filter, first, last, 21251, "epsg", 21251,
        "GSK-2011 / GSK 3GK zone 51", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=51250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 51\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",153],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",51250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21251\"]]");
    p = add_epsg_def_ex (filter, first, last, 21252, "epsg", 21252,
        "GSK-2011 / GSK 3GK zone 52", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=52250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 52\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",156],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",52250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21252\"]]");
    p = add_epsg_def_ex (filter, first, last, 21253, "epsg", 21253,
        "GSK-2011 / GSK 3GK zone 53", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=53250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 53\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",159],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",53250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21253\"]]");
    p = add_epsg_def_ex (filter, first, last, 21254, "epsg", 21254,
        "GSK-2011 / GSK 3GK zone 54", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=54250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 54\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",162],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",54250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21254\"]]");
    p = add_epsg_def_ex (filter, first, last, 21255, "epsg", 21255,
        "GSK-2011 / GSK 3GK zone 55", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=55250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 55\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",165],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",55250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21255\"]]");
    p = add_epsg_def_ex (filter, first, last, 21256, "epsg", 21256,
        "GSK-2011 / GSK 3GK zone 56", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=56250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 56\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",168],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",56250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21256\"]]");
    p = add_epsg_def_ex (filter, first, last, 21257, "epsg", 21257,
        "GSK-2011 / GSK 3GK zone 57", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=57250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 57\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",171],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",57250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21257\"]]");
    p = add_epsg_def_ex (filter, first, last, 21258, "epsg", 21258,
        "GSK-2011 / GSK 3GK zone 58", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=58250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 58\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",174],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",58250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21258\"]]");
    p = add_epsg_def_ex (filter, first, last, 21259, "epsg", 21259,
        "GSK-2011 / GSK 3GK zone 59", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=177 +k=1 +x_0=59250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 59\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",177],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",59250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21259\"]]");
    p = add_epsg_def_ex (filter, first, last, 21260, "epsg", 21260,
        "GSK-2011 / GSK 3GK zone 60", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=180 +k=1 +x_0=60250000 +y_0=");
    add_proj4text (p, 1,
        "0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_def");
    add_proj4text (p, 2,
        "s");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 60\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",180],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",60250000],PARAMETER[\"false_northing");
    add_srs_wkt (p, 10,
        "\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXI");
    add_srs_wkt (p, 11,
        "S[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"");
    add_srs_wkt (p, 12,
        "EPSG\",\"21260\"]]");
    p = add_epsg_def_ex (filter, first, last, 21261, "epsg", 21261,
        "GSK-2011 / GSK 3GK zone 61", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-177 +k=1 +x_0=61250000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 61\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-177],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",61250000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"21261\"]]");
    p = add_epsg_def_ex (filter, first, last, 21262, "epsg", 21262,
        "GSK-2011 / GSK 3GK zone 62", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-174 +k=1 +x_0=62250000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 62\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-174],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",62250000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"21262\"]]");
    p = add_epsg_def_ex (filter, first, last, 21263, "epsg", 21263,
        "GSK-2011 / GSK 3GK zone 63", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-171 +k=1 +x_0=63250000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 63\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-171],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",63250000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"21263\"]]");
    p = add_epsg_def_ex (filter, first, last, 21264, "epsg", 21264,
        "GSK-2011 / GSK 3GK zone 64", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-168 +k=1 +x_0=64250000 +y_0");
    add_proj4text (p, 1,
        "=0 +ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_de");
    add_proj4text (p, 2,
        "fs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK zone 64\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",-168],PARAMETER[\"scale_factor\",1],PARAMET");
    add_srs_wkt (p, 9,
        "ER[\"false_easting\",64250000],PARAMETER[\"false_northin");
    add_srs_wkt (p, 10,
        "g\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AX");
    add_srs_wkt (p, 11,
        "IS[\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[");
    add_srs_wkt (p, 12,
        "\"EPSG\",\"21264\"]]");
    p = add_epsg_def_ex (filter, first, last, 21291, "epsg", 21291,
        "Barbados 1938 / British West Indies Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=-62 +k=0.9995000000000001 +x");
    add_proj4text (p, 1,
        "_0=400000 +y_0=0 +ellps=clrk80 +towgs84=31.95,300.99,419");
    add_proj4text (p, 2,
        ".19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Barbados 1938 / British West Indies Grid\",GEOG");
    add_srs_wkt (p, 1,
        "CS[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROID[\"");
    add_srs_wkt (p, 2,
        "Clarke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG");
    add_srs_wkt (p, 3,
        "\",\"7012\"]],AUTHORITY[\"EPSG\",\"6212\"]],PRIMEM[\"Gre");
    add_srs_wkt (p, 4,
        "enwich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\"");
    add_srs_wkt (p, 5,
        ",0.0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHOR");
    add_srs_wkt (p, 6,
        "ITY[\"EPSG\",\"4212\"]],PROJECTION[\"Transverse_Mercator");
    add_srs_wkt (p, 7,
        "\"],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"cent");
    add_srs_wkt (p, 8,
        "ral_meridian\",-62],PARAMETER[\"scale_factor\",0.9995],P");
    add_srs_wkt (p, 9,
        "ARAMETER[\"false_easting\",400000],PARAMETER[\"false_nor");
    add_srs_wkt (p, 10,
        "thing\",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]");
    add_srs_wkt (p, 11,
        "],AXIS[\"Easting\",EAST],AXIS[\"Northing\",NORTH],AUTHOR");
    add_srs_wkt (p, 12,
        "ITY[\"EPSG\",\"21291\"]]");
    p = add_epsg_def_ex (filter, first, last, 21292, "epsg", 21292,
        "Barbados 1938 / Barbados National Grid", 0, 0,
        "Clarke 1880 (RGS)", "Greenwich",
        "Barbados_1938", "Transverse_Mercator", "metre",
        "Easting", "East", "Northing", "North");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=13.17638888888889 +lon_0=-59.55972222");
    add_proj4text (p, 1,
        "222222 +k=0.9999986 +x_0=30000 +y_0=75000 +ellps=clrk80 ");
    add_proj4text (p, 2,
        "+towgs84=31.95,300.99,419.19,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"Barbados 1938 / Barbados National Grid\",GEOGCS");
    add_srs_wkt (p, 1,
        "[\"Barbados 1938\",DATUM[\"Barbados_1938\",SPHEROID[\"Cl");
    add_srs_wkt (p, 2,
        "arke 1880 (RGS)\",6378249.145,293.465,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"7012\"]],AUTHORITY[\"EPSG\",\"6212\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"4212\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",13.1763888888889],PAR");
    add_srs_wkt (p, 8,
        "AMETER[\"central_meridian\",-59.5597222222222],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"scale_factor\",0.9999986],PARAMETER[\"false_easting\"");
    add_srs_wkt (p, 10,
        ",30000],PARAMETER[\"false_northing\",75000],UNIT[\"metre");
    add_srs_wkt (p, 11,
        "\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"Easting\",EAST");
    add_srs_wkt (p, 12,
        "],AXIS[\"Northing\",NORTH],AUTHORITY[\"EPSG\",\"21292\"]");
    add_srs_wkt (p, 13,
        "]");
    p = add_epsg_def_ex (filter, first, last, 21307, "epsg", 21307,
        "GSK-2011 / GSK 3GK CM 21E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=21 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 21E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",21],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21307\"]]");
    p = add_epsg_def_ex (filter, first, last, 21308, "epsg", 21308,
        "GSK-2011 / GSK 3GK CM 24E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=24 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 24E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",24],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21308\"]]");
    p = add_epsg_def_ex (filter, first, last, 21309, "epsg", 21309,
        "GSK-2011 / GSK 3GK CM 27E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=27 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 27E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",27],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21309\"]]");
    p = add_epsg_def_ex (filter, first, last, 21310, "epsg", 21310,
        "GSK-2011 / GSK 3GK CM 30E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=30 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 30E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",30],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21310\"]]");
    p = add_epsg_def_ex (filter, first, last, 21311, "epsg", 21311,
        "GSK-2011 / GSK 3GK CM 33E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=33 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 33E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",33],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21311\"]]");
    p = add_epsg_def_ex (filter, first, last, 21312, "epsg", 21312,
        "GSK-2011 / GSK 3GK CM 36E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=36 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 36E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",36],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21312\"]]");
    p = add_epsg_def_ex (filter, first, last, 21313, "epsg", 21313,
        "GSK-2011 / GSK 3GK CM 39E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=39 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 39E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",39],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21313\"]]");
    p = add_epsg_def_ex (filter, first, last, 21314, "epsg", 21314,
        "GSK-2011 / GSK 3GK CM 42E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=42 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 42E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",42],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21314\"]]");
    p = add_epsg_def_ex (filter, first, last, 21315, "epsg", 21315,
        "GSK-2011 / GSK 3GK CM 45E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=45 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 45E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",45],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21315\"]]");
    p = add_epsg_def_ex (filter, first, last, 21316, "epsg", 21316,
        "GSK-2011 / GSK 3GK CM 48E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=48 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 48E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",48],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21316\"]]");
    p = add_epsg_def_ex (filter, first, last, 21317, "epsg", 21317,
        "GSK-2011 / GSK 3GK CM 51E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=51 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 51E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",51],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21317\"]]");
    p = add_epsg_def_ex (filter, first, last, 21318, "epsg", 21318,
        "GSK-2011 / GSK 3GK CM 54E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=54 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 54E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",54],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21318\"]]");
    p = add_epsg_def_ex (filter, first, last, 21319, "epsg", 21319,
        "GSK-2011 / GSK 3GK CM 57E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=57 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 57E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",57],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21319\"]]");
    p = add_epsg_def_ex (filter, first, last, 21320, "epsg", 21320,
        "GSK-2011 / GSK 3GK CM 60E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=60 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 60E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",60],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21320\"]]");
    p = add_epsg_def_ex (filter, first, last, 21321, "epsg", 21321,
        "GSK-2011 / GSK 3GK CM 63E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=63 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 63E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",63],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21321\"]]");
    p = add_epsg_def_ex (filter, first, last, 21322, "epsg", 21322,
        "GSK-2011 / GSK 3GK CM 66E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=66 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 66E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",66],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21322\"]]");
    p = add_epsg_def_ex (filter, first, last, 21323, "epsg", 21323,
        "GSK-2011 / GSK 3GK CM 69E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=69 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 69E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",69],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21323\"]]");
    p = add_epsg_def_ex (filter, first, last, 21324, "epsg", 21324,
        "GSK-2011 / GSK 3GK CM 72E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=72 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 72E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",72],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21324\"]]");
    p = add_epsg_def_ex (filter, first, last, 21325, "epsg", 21325,
        "GSK-2011 / GSK 3GK CM 75E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=75 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 75E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",75],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21325\"]]");
    p = add_epsg_def_ex (filter, first, last, 21326, "epsg", 21326,
        "GSK-2011 / GSK 3GK CM 78E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=78 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 78E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",78],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21326\"]]");
    p = add_epsg_def_ex (filter, first, last, 21327, "epsg", 21327,
        "GSK-2011 / GSK 3GK CM 81E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=81 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 81E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",81],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21327\"]]");
    p = add_epsg_def_ex (filter, first, last, 21328, "epsg", 21328,
        "GSK-2011 / GSK 3GK CM 84E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=84 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 84E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",84],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21328\"]]");
    p = add_epsg_def_ex (filter, first, last, 21329, "epsg", 21329,
        "GSK-2011 / GSK 3GK CM 87E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=87 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 87E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",87],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21329\"]]");
    p = add_epsg_def_ex (filter, first, last, 21330, "epsg", 21330,
        "GSK-2011 / GSK 3GK CM 90E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=90 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 90E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",90],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21330\"]]");
    p = add_epsg_def_ex (filter, first, last, 21331, "epsg", 21331,
        "GSK-2011 / GSK 3GK CM 93E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=93 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 93E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",93],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21331\"]]");
    p = add_epsg_def_ex (filter, first, last, 21332, "epsg", 21332,
        "GSK-2011 / GSK 3GK CM 96E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=96 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 96E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",96],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21332\"]]");
    p = add_epsg_def_ex (filter, first, last, 21333, "epsg", 21333,
        "GSK-2011 / GSK 3GK CM 99E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=99 +k=1 +x_0=250000 +y_0=0 +");
    add_proj4text (p, 1,
        "ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 99E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",99],PARAMETER[\"scale_factor\",1],PARAMETER");
    add_srs_wkt (p, 9,
        "[\"false_easting\",250000],PARAMETER[\"false_northing\",");
    add_srs_wkt (p, 10,
        "0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[\"");
    add_srs_wkt (p, 11,
        "Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"EPS");
    add_srs_wkt (p, 12,
        "G\",\"21333\"]]");
    p = add_epsg_def_ex (filter, first, last, 21334, "epsg", 21334,
        "GSK-2011 / GSK 3GK CM 102E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=102 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 102E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",102],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21334\"]]");
    p = add_epsg_def_ex (filter, first, last, 21335, "epsg", 21335,
        "GSK-2011 / GSK 3GK CM 105E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=105 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 105E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",105],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21335\"]]");
    p = add_epsg_def_ex (filter, first, last, 21336, "epsg", 21336,
        "GSK-2011 / GSK 3GK CM 108E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=108 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 108E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",108],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21336\"]]");
    p = add_epsg_def_ex (filter, first, last, 21337, "epsg", 21337,
        "GSK-2011 / GSK 3GK CM 111E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=111 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 111E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",111],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21337\"]]");
    p = add_epsg_def_ex (filter, first, last, 21338, "epsg", 21338,
        "GSK-2011 / GSK 3GK CM 114E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=114 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 114E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",114],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21338\"]]");
    p = add_epsg_def_ex (filter, first, last, 21339, "epsg", 21339,
        "GSK-2011 / GSK 3GK CM 117E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=117 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 117E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",117],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21339\"]]");
    p = add_epsg_def_ex (filter, first, last, 21340, "epsg", 21340,
        "GSK-2011 / GSK 3GK CM 120E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=120 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 120E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",120],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21340\"]]");
    p = add_epsg_def_ex (filter, first, last, 21341, "epsg", 21341,
        "GSK-2011 / GSK 3GK CM 123E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=123 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 123E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",123],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21341\"]]");
    p = add_epsg_def_ex (filter, first, last, 21342, "epsg", 21342,
        "GSK-2011 / GSK 3GK CM 126E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=126 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 126E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",126],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21342\"]]");
    p = add_epsg_def_ex (filter, first, last, 21343, "epsg", 21343,
        "GSK-2011 / GSK 3GK CM 129E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=129 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 129E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",129],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21343\"]]");
    p = add_epsg_def_ex (filter, first, last, 21344, "epsg", 21344,
        "GSK-2011 / GSK 3GK CM 132E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=132 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 132E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",132],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21344\"]]");
    p = add_epsg_def_ex (filter, first, last, 21345, "epsg", 21345,
        "GSK-2011 / GSK 3GK CM 135E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=135 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 135E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",135],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21345\"]]");
    p = add_epsg_def_ex (filter, first, last, 21346, "epsg", 21346,
        "GSK-2011 / GSK 3GK CM 138E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=138 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 138E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",138],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21346\"]]");
    p = add_epsg_def_ex (filter, first, last, 21347, "epsg", 21347,
        "GSK-2011 / GSK 3GK CM 141E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=141 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 141E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",141],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21347\"]]");
    p = add_epsg_def_ex (filter, first, last, 21348, "epsg", 21348,
        "GSK-2011 / GSK 3GK CM 144E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=144 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 144E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",144],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21348\"]]");
    p = add_epsg_def_ex (filter, first, last, 21349, "epsg", 21349,
        "GSK-2011 / GSK 3GK CM 147E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=147 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 147E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",147],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21349\"]]");
    p = add_epsg_def_ex (filter, first, last, 21350, "epsg", 21350,
        "GSK-2011 / GSK 3GK CM 150E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=150 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 150E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",150],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21350\"]]");
    p = add_epsg_def_ex (filter, first, last, 21351, "epsg", 21351,
        "GSK-2011 / GSK 3GK CM 153E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=153 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 153E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",153],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21351\"]]");
    p = add_epsg_def_ex (filter, first, last, 21352, "epsg", 21352,
        "GSK-2011 / GSK 3GK CM 156E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=156 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 156E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",156],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21352\"]]");
    p = add_epsg_def_ex (filter, first, last, 21353, "epsg", 21353,
        "GSK-2011 / GSK 3GK CM 159E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=159 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 159E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",159],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21353\"]]");
    p = add_epsg_def_ex (filter, first, last, 21354, "epsg", 21354,
        "GSK-2011 / GSK 3GK CM 162E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=162 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 162E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",162],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21354\"]]");
    p = add_epsg_def_ex (filter, first, last, 21355, "epsg", 21355,
        "GSK-2011 / GSK 3GK CM 165E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=165 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 165E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",165],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21355\"]]");
    p = add_epsg_def_ex (filter, first, last, 21356, "epsg", 21356,
        "GSK-2011 / GSK 3GK CM 168E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=168 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 168E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",168],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21356\"]]");
    p = add_epsg_def_ex (filter, first, last, 21357, "epsg", 21357,
        "GSK-2011 / GSK 3GK CM 171E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=171 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 171E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",171],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21357\"]]");
    p = add_epsg_def_ex (filter, first, last, 21358, "epsg", 21358,
        "GSK-2011 / GSK 3GK CM 174E", 0, 1,
        "GSK-2011", "Greenwich",
        "Geodezicheskaya_Sistema_Koordinat_2011", "Transverse_Mercator", "metre",
        "Northing", "North", "Easting", "East");
    add_proj4text (p, 0,
        "+proj=tmerc +lat_0=0 +lon_0=174 +k=1 +x_0=250000 +y_0=0 ");
    add_proj4text (p, 1,
        "+ellps=GSK2011 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs");
    add_srs_wkt (p, 0,
        "PROJCS[\"GSK-2011 / GSK 3GK CM 174E\",GEOGCS[\"GSK-2011\"");
    add_srs_wkt (p, 1,
        ",DATUM[\"Geodezicheskaya_Sistema_Koordinat_2011\",SPHERO");
    add_srs_wkt (p, 2,
        "ID[\"GSK-2011\",6378136.5,298.2564151,AUTHORITY[\"EPSG\"");
    add_srs_wkt (p, 3,
        ",\"1025\"]],AUTHORITY[\"EPSG\",\"1159\"]],PRIMEM[\"Green");
    add_srs_wkt (p, 4,
        "wich\",0,AUTHORITY[\"EPSG\",\"8901\"]],UNIT[\"degree\",0");
    add_srs_wkt (p, 5,
        ".0174532925199433,AUTHORITY[\"EPSG\",\"9122\"]],AUTHORIT");
    add_srs_wkt (p, 6,
        "Y[\"EPSG\",\"7683\"]],PROJECTION[\"Transverse_Mercator\"");
    add_srs_wkt (p, 7,
        "],PARAMETER[\"latitude_of_origin\",0],PARAMETER[\"centra");
    add_srs_wkt (p, 8,
        "l_meridian\",174],PARAMETER[\"scale_factor\",1],PARAMETE");
    add_srs_wkt (p, 9,
        "R[\"false_easting\",250000],PARAMETER[\"false_northing\"");
    add_srs_wkt (p, 10,
        ",0],UNIT[\"metre\",1,AUTHORITY[\"EPSG\",\"9001\"]],AXIS[");
    add_srs_wkt (p, 11,
        "\"Northing\",NORTH],AXIS[\"Easting\",EAST],AUTHORITY[\"E");
    add_srs_wkt (p, 12,
        "PSG\",\"21358\"]]");
}

#endif /* full EPSG initialization enabled/disabled */

