/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.bristol.star.cdf.record;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.util.logging.Logger;
import uk.ac.bristol.star.cdf.record.BankBuf;
import uk.ac.bristol.star.cdf.record.Buf;
import uk.ac.bristol.star.cdf.record.Compression;
import uk.ac.bristol.star.cdf.record.SimpleNioBuf;

public class Bufs {
    private static final int BANK_SIZE = 0x40000000;
    private static Logger logger_ = Logger.getLogger(Bufs.class.getName());

    private Bufs() {
    }

    public static Buf createBuf(ByteBuffer byteBuffer, boolean bl, boolean bl2) {
        return new SimpleNioBuf(byteBuffer, bl, bl2);
    }

    public static Buf createBuf(ByteBuffer[] byteBufferArray, boolean bl, boolean bl2) {
        return byteBufferArray.length == 1 ? Bufs.createBuf(byteBufferArray[0], bl, bl2) : BankBuf.createMultiBankBuf(byteBufferArray, bl, bl2);
    }

    public static Buf createBuf(File file, boolean bl, boolean bl2) throws IOException {
        FileChannel fileChannel = new FileInputStream(file).getChannel();
        long l = file.length();
        if (l <= Integer.MAX_VALUE) {
            int n = (int)l;
            MappedByteBuffer mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, 0L, n);
            return Bufs.createBuf(mappedByteBuffer, bl, bl2);
        }
        return BankBuf.createMultiBankBuf(fileChannel, l, 0x40000000, bl, bl2);
    }

    public static Buf uncompress(Compression compression, Buf buf, long l, long l2) throws IOException {
        logger_.config("Uncompressing CDF data to new " + l2 + "-byte buffer");
        InputStream inputStream = compression.uncompressStream(new BufferedInputStream(buf.createInputStream(l)));
        Buf buf2 = buf.fillNewBuf(l2, inputStream);
        inputStream.close();
        return buf2;
    }

    public static InputStream createByteBufferInputStream(ByteBuffer byteBuffer) {
        return new ByteBufferInputStream(byteBuffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static String readAsciiString(ByteBuffer byteBuffer, int n, int n2) {
        byte by;
        byte[] byArray = new byte[n2];
        Comparable<ByteBuffer> comparable = byteBuffer;
        synchronized (comparable) {
            byteBuffer.position(n);
            byteBuffer.get(byArray, 0, n2);
        }
        comparable = new StringBuffer(n2);
        for (int i = 0; i < n2 && (by = byArray[i]) != 0; ++i) {
            ((StringBuffer)comparable).append((char)by);
        }
        return ((StringBuffer)comparable).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readBytes(ByteBuffer byteBuffer, int n, int n2, byte[] byArray) {
        if (n2 == 1) {
            byArray[0] = byteBuffer.get(n);
        } else {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                byteBuffer.position(n);
                byteBuffer.get(byArray, 0, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readShorts(ByteBuffer byteBuffer, int n, int n2, short[] sArray) {
        if (n2 == 1) {
            sArray[0] = byteBuffer.getShort(n);
        } else {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                byteBuffer.position(n);
                byteBuffer.asShortBuffer().get(sArray, 0, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readInts(ByteBuffer byteBuffer, int n, int n2, int[] nArray) {
        if (n2 == 1) {
            nArray[0] = byteBuffer.getInt(n);
        } else {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                byteBuffer.position(n);
                byteBuffer.asIntBuffer().get(nArray, 0, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readLongs(ByteBuffer byteBuffer, int n, int n2, long[] lArray) {
        if (n2 == 1) {
            lArray[0] = byteBuffer.getLong(n);
        } else {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                byteBuffer.position(n);
                byteBuffer.asLongBuffer().get(lArray, 0, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readFloats(ByteBuffer byteBuffer, int n, int n2, float[] fArray) {
        if (n2 == 1) {
            fArray[0] = byteBuffer.getFloat(n);
        } else {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                byteBuffer.position(n);
                byteBuffer.asFloatBuffer().get(fArray, 0, n2);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void readDoubles(ByteBuffer byteBuffer, int n, int n2, double[] dArray) {
        if (n2 == 1) {
            dArray[0] = byteBuffer.getDouble(n);
        } else {
            ByteBuffer byteBuffer2 = byteBuffer;
            synchronized (byteBuffer2) {
                byteBuffer.position(n);
                byteBuffer.asDoubleBuffer().get(dArray, 0, n2);
            }
        }
    }

    private static class ByteBufferInputStream
    extends InputStream {
        private final ByteBuffer bbuf_;

        ByteBufferInputStream(ByteBuffer byteBuffer) {
            this.bbuf_ = byteBuffer;
        }

        public int read() {
            return this.bbuf_.remaining() > 0 ? (int)this.bbuf_.get() : -1;
        }

        public int read(byte[] byArray) {
            return this.read(byArray, 0, byArray.length);
        }

        public int read(byte[] byArray, int n, int n2) {
            if (n2 == 0) {
                return 0;
            }
            int n3 = this.bbuf_.remaining();
            if (n3 == 0) {
                return -1;
            }
            int n4 = Math.min(n3, n2);
            this.bbuf_.get(byArray, n, n4);
            return n4;
        }

        public boolean markSupported() {
            return true;
        }

        public void mark(int n) {
            this.bbuf_.mark();
        }

        public void reset() {
            this.bbuf_.reset();
        }

        public long skip(long l) {
            int n = (int)Math.min(l, (long)this.bbuf_.remaining());
            this.bbuf_.position(this.bbuf_.position() + n);
            return n;
        }

        public int available() {
            return this.bbuf_.remaining();
        }
    }
}

