/* ====================================================================
 * Copyright (c) 2007,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#include "ProjectSorterTest.h"

// cppunit
#include <cppunit/TestSuite.h>
#include <cppunit/TestCaller.h>

// sc
#include "subcommander/ProjectSorter.h"
#include "subcommander/Project.h"
#include "util/uuid.h"
#include "util/String.h"


void ProjectSorterTest::setUp()
{
  Uuid uuid = Uuid::createUuid();
  _uuid6 = new Uuid(uuid);
  _projects.push_back( new Project(uuid, sc::String("6")) );
  _projects[0]->setSortPos(6);

  uuid = Uuid::createUuid();
  _uuid1 = new Uuid(uuid);
  _projects.push_back( new Project(uuid, sc::String("1")) );
  _projects[1]->setSortPos(1);

  uuid = Uuid::createUuid();
  _projects.push_back( new Project(uuid, sc::String("3")) );
  _projects[2]->setSortPos(3);

  uuid = Uuid::createUuid();
  _projects.push_back( new Project(uuid, sc::String("2")) );
  _projects[3]->setSortPos(2);

  uuid = Uuid::createUuid();
  _projects.push_back( new Project(uuid, sc::String("7")) );
  _projects[4]->setSortPos(7);

  uuid = Uuid::createUuid();
  _projects.push_back( new Project(uuid, sc::String("5")) );
  _projects[5]->setSortPos(5);
}

void ProjectSorterTest::tearDown()
{
  for( Projects::iterator it = _projects.begin(); it != _projects.end(); it++ )
  {
    delete *it;
  }

  delete _uuid1;
  delete _uuid6;
}

void ProjectSorterTest::testCleanupSortPosition()
{
  ProjectSorter sorter(_projects);

  sorter.cleanupSortPositions();

  const Projects& projects = sorter.getProjects();

  long expectedSortPos = 0;
  for( Projects::const_iterator it = projects.begin(); it != projects.end(); it++ )
  {
    CPPUNIT_ASSERT_EQUAL( expectedSortPos, (*it)->getSortPos() );

    expectedSortPos++;
  }
}

void ProjectSorterTest::testMove()
{
  // 1 2 3 5 6 7 => 2 3 5 6 1 7

  ProjectSorter sorter(_projects);

  sorter.move( 1, 6 );

  const Projects& projects = sorter.getProjects();

  CPPUNIT_ASSERT( *_uuid1 == projects[4]->getId() );
  CPPUNIT_ASSERT( *_uuid6 == projects[3]->getId() );
}
