/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MERGEPARAM_H
#define _SC_MERGEPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"

/**
 * Parameter class for MergeCmd.
 */
class MergeParam : public ScParam
{
public:
  MergeParam(
    const char* pathOrUrl1, const svn::RevisionPtr rev1,
    const char* pathOrUrl2, const svn::RevisionPtr rev2,
    bool peg, const svn::RevisionPtr revPeg, const char* targetPath,
    bool recurse, bool ancestry, bool interactive, bool force,
    bool dryrun )
  : _pathOrUrl1(pathOrUrl1), _rev1(rev1),
    _pathOrUrl2(pathOrUrl2), _rev2(rev2),
    _peg(peg), _revPeg(revPeg), _targetPath(targetPath),
    _recurse(recurse), _ancestry(ancestry),
    _interactive(interactive), _force(force),
    _dryrun(dryrun)
  {
  }

  ~MergeParam()
  {
  }

  bool isPeg() const
  {
    return _peg;
  }

  const sc::String& getPathOrUrl1() const
  {
    return _pathOrUrl1;
  }

  const sc::String& getPathOrUrl2() const
  {
    return _pathOrUrl2;
  }

  svn::RevisionPtr getPegRevision() const
  {
    return _revPeg;
  }

  svn::RevisionPtr getRevision1() const
  {
    return _rev1;
  }

  svn::RevisionPtr getRevision2() const
  {
    return _rev2;
  }

  const sc::String& getTargetPath() const
  {
    return _targetPath;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  bool getAncestry() const
  {
    return _ancestry;
  }

  bool getInteractive() const
  {
    return _interactive;
  }

  bool getForce() const
  {
    return _force;
  }

  bool getDryRun() const
  {
    return _dryrun;
  }

  ScParamAccept(MergeParam);

private:
  // in
  sc::String           _pathOrUrl1;
  svn::RevisionPtr     _rev1;

  sc::String           _pathOrUrl2;   ///< only valid if _revPeg is 0
  svn::RevisionPtr     _rev2;

  bool                 _peg;
  svn::RevisionPtr     _revPeg;

  sc::String           _targetPath;
  bool                 _recurse;
  bool                 _ancestry;
  bool                 _interactive;
  bool                 _force;
  bool                 _dryrun;
};

#endif // _SC_MERGEPARAM_H
