/*-----------------------------------------------------------------------

                         SYRTHES version 3.4
                         -------------------

     This file is part of the SYRTHES Kernel, element of the
     thermal code SYRTHES.

     Copyright (C) 1988-2008 EDF S.A., France

     contact: syrthes-support@edf.fr


     The SYRTHES Kernel is free software; you can redistribute it
     and/or modify it under the terms of the GNU General Public License
     as published by the Free Software Foundation; either version 2 of
     the License, or (at your option) any later version.

     The SYRTHES Kernel is distributed in the hope that it will be
     useful, but WITHOUT ANY WARRANTY; without even the implied warranty
     of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
     GNU General Public License for more details.


     You should have received a copy of the GNU General Public License
     along with the Code_Saturne Kernel; if not, write to the
     Free Software Foundation, Inc.,
     51 Franklin St, Fifth Floor,
     Boston, MA  02110-1301  USA

-----------------------------------------------------------------------*/
#include "f2c_syrthes.h"
#include <stdio.h>
#include <stdlib.h>
#define SYRTHES_CHRONO 1
/*
 --------------------------------------------------------------
!         Recuperation du temps cpu pris par un process.        ! 
!         SUN(et CONVEX) ou CETIA : choisir le bon define       !
!                                                               !
! REFERENCE : SUN UNIX INTERFACE REFERENCE page 59 (et 63)      !
!             CETIA UNIX SYSTEM V Reference Manual Chapter 4    !
!                   Fonction times(2)                           !
!                                                               !
! attention suivant machine unix les noms des subroutines       !
! a l'appel ont besoin ou non d'un _  : proc                          !
! exemple dgetcp_ sur convex et dgetcp sur hp9000               !
 ---------------------------------------------------------------
*/
/*########*/
#ifdef SUN
/*########*/
#include <sys/time.h>
#include <sys/resource.h>
proc(dgetcp,DGETCP) (t)

/* retourne le temps cpu sous la forme d'un tableau d'entiers
   t[0]=secondes pour le system mode
   t[1]=microsecondes pour le system mode
   t[2]= secondes pour le user mode
   t[3]= microsecondes pour le user mode

 temps cpu = somme des temps en user et system mode

Remarque : pour avoir le temps cpu des process fils, il suffit de remplacer
           RUSAGE_SELF par RUSAGE_CHILDREN dans l'appel a getrusage.
*/
double t[4];
{
   struct rusage cpu;

         getrusage(RUSAGE_SELF,&cpu);

         t[0]=(double)cpu.ru_stime.tv_sec;
         t[1]=(double)cpu.ru_stime.tv_usec;
         t[2]=(double)cpu.ru_utime.tv_sec;
         t[3]=(double)cpu.ru_utime.tv_usec;
}
#endif
/*#################*/
#ifdef SYRTHES_CHRONO
/*#################*/
#include <sys/times.h>
proc(dgetcp,DGETCP) (t)

double t[4];
{
   struct tms cpu;

         times(&cpu);

         t[0]=(double)cpu.tms_utime;
         t[1]=(double)cpu.tms_stime;
         t[2]=(double)cpu.tms_utime;
         t[3]=(double)cpu.tms_stime;
}
#endif
