#!/usr/bin/perl

package eBay::API::XML::Call::GetMyMessages::GetMyMessagesResponseType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. GetMyMessagesResponseType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::GetMyMessages::GetMyMessagesResponseType

=head1 DESCRIPTION

Conains information about the messages and alerts sent to
a given user. Depending on the detail level, this
information can include message and alert counts,
resolution and flagged status, message and/or alert
headers, and message and/or alert body text.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::GetMyMessages::GetMyMessagesResponseType inherits from the L<eBay::API::XML::ResponseDataType> class

=cut

use eBay::API::XML::ResponseDataType;
our @ISA = ("eBay::API::XML::ResponseDataType");

use eBay::API::XML::DataType::MyMessagesAlertArrayType;
use eBay::API::XML::DataType::MyMessagesMessageArrayType;
use eBay::API::XML::DataType::MyMessagesSummaryType;


my @gaProperties = ( [ 'Alerts', 'ns:MyMessagesAlertArrayType', ''
	     ,'eBay::API::XML::DataType::MyMessagesAlertArrayType', '1' ]
	, [ 'Messages', 'ns:MyMessagesMessageArrayType', ''
	     ,'eBay::API::XML::DataType::MyMessagesMessageArrayType', '1' ]
	, [ 'Summary', 'ns:MyMessagesSummaryType', ''
	     ,'eBay::API::XML::DataType::MyMessagesSummaryType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::ResponseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::ResponseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAlerts()

Contains the alert information for each alert
specified in AlertIDs. The amount and type of
information returned varies based on the
requested detail level. Contains one
MyMessagesAlertType object per alert. Returned
as an empty node if user has no alerts.

#    Argument: 'ns:MyMessagesAlertArrayType'

=cut

sub setAlerts {
  my $self = shift;
  $self->{'Alerts'} = shift
}

=head2 getAlerts()

  Returned: Conditionally
  Details: DetailLevel: ReturnHeaders, ReturnMessages
#    Returns: 'ns:MyMessagesAlertArrayType'

=cut

sub getAlerts {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Alerts'
		,'eBay::API::XML::DataType::MyMessagesAlertArrayType');
}


=head2 setMessages()

Contains the message information for each
message specified in MessageIDs. The amount and
type of information returned varies based on the
requested detail level. Contains one
MyMessagesMessageType object per message.
Returned as an empty node if user has no
messages.

#    Argument: 'ns:MyMessagesMessageArrayType'

=cut

sub setMessages {
  my $self = shift;
  $self->{'Messages'} = shift
}

=head2 getMessages()

  Returned: Conditionally
  Details: DetailLevel: ReturnHeaders, ReturnMessages
#    Returns: 'ns:MyMessagesMessageArrayType'

=cut

sub getMessages {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Messages'
		,'eBay::API::XML::DataType::MyMessagesMessageArrayType');
}


=head2 setSummary()

Summary data for a given user's alerts and
messages. This includes the numbers of
new alerts and messages, unresolved alerts,
flagged messages, and total alerts and messages.
The amount and type of data returned is the same
whether or not the request included specific
AlertID or MessageID values.
Always/Conditionally returned logic assumes a
detail level of ReturnMessages.

#    Argument: 'ns:MyMessagesSummaryType'

=cut

sub setSummary {
  my $self = shift;
  $self->{'Summary'} = shift
}

=head2 getSummary()

  Returned: Conditionally
  Details: DetailLevel: ReturnSummary
#    Returns: 'ns:MyMessagesSummaryType'

=cut

sub getSummary {
  my $self = shift;
  return $self->_getDataTypeInstance( 'Summary'
		,'eBay::API::XML::DataType::MyMessagesSummaryType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
