#!/usr/bin/perl

package eBay::API::XML::DataType::CalculatedHandlingDiscountType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. CalculatedHandlingDiscountType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::DataType::CalculatedHandlingDiscountType

=head1 DESCRIPTION

Instructions on packaging/handling costs for combined payment.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::DataType::CalculatedHandlingDiscountType inherits from the L<eBay::API::XML::BaseDataType> class

=cut

use eBay::API::XML::BaseDataType;
our @ISA = ("eBay::API::XML::BaseDataType");

use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::Enum::HandlingNameCodeType;


my @gaProperties = ( [ 'DiscountName', 'ns:HandlingNameCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::HandlingNameCodeType', '' ]
	, [ 'EachAdditionalAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'EachAdditionalOffAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'EachAdditionalPercentOff', 'xs:float', '', '', '' ]
	, [ 'OrderHandlingAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
                    );
push @gaProperties, @{eBay::API::XML::BaseDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::BaseDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setDiscountName()

The type of discount that is detailed in the profile.
If the selection is EachAdditionalAmount, EachAdditionalAmountOff or
EachAdditionalPercentOff, the value is set in the child element of same
name in CalculatedHandlingDiscount. If the selection is CombinedHandlingFee,
specify the amount in CalculatedHandlingDiscount.OrderHandlingAmount.
If the selection is IndividualHandlingFee, the amount is determined by eBay
by adding the fees of the individual items.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

#    Argument: 'ns:HandlingNameCodeType'

=cut

sub setDiscountName {
  my $self = shift;
  $self->{'DiscountName'} = shift
}

=head2 getDiscountName()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

#    Returns: 'ns:HandlingNameCodeType'

=cut

sub getDiscountName {
  my $self = shift;
  return $self->{'DiscountName'};
}


=head2 setEachAdditionalAmount()

The packaging/handling cost for each item beyond the first item (where the
item with the highest packaging/handling cost is selected by eBay as the first
item). Let's say the buyer purchases three items, each assigned a
packaging/handling cost of $8, and the seller set EachAdditionalAmount to $6.
The packaging/handling cost for three items would normally be $24, but since
the seller specified $6, the total packaging/handling cost would be $8 + $6 +
$6, or $20.
This field is mutually exclusive with the other amount and percentage
fields within this type.
This field only applies when DiscountName is EachAdditionalAmount.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

#    Argument: 'ns:AmountType'

=cut

sub setEachAdditionalAmount {
  my $self = shift;
  $self->{'EachAdditionalAmount'} = shift
}

=head2 getEachAdditionalAmount()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getEachAdditionalAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'EachAdditionalAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setEachAdditionalOffAmount()

The amount by which to reduce the packaging/handling cost for each item beyond
the first item (where the item with the highest packaging/handling cost is
selected by eBay as the first item). Let's say the buyer purchases three
items, each assigned a packaging/handling cost of $8, and the seller set
EachAdditionalAmountOff to $2.  The packaging/handling cost for three items
would normally be $24, but since the seller specified $2, the total
packaging/handling cost would be $24 - (two additional items x $2), or $20.
This field is mutually exclusive with the other amount and percentage
fields within this type.
This field only applies when DiscountName is EachAdditionalOffAmount.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

#    Argument: 'ns:AmountType'

=cut

sub setEachAdditionalOffAmount {
  my $self = shift;
  $self->{'EachAdditionalOffAmount'} = shift
}

=head2 getEachAdditionalOffAmount()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getEachAdditionalOffAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'EachAdditionalOffAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setEachAdditionalPercentOff()

The percentage by which to reduce the packaging/handling cost for each item
beyond the first item (where the item with the highest packaging/handling cost
is selected by eBay as the first item). Let's say the buyer purchases three
items, each assigned a packaging/handling cost of $8, and the seller set
EachAdditionalPercentOff to 0.25.  The packaging/handling cost for three items
would normally be $24, but since the seller specified 0.25 ($2 out of 8), the
total packaging/handling cost would be $24 - (two additional items x $2), or
$20.
This field is mutually exclusive with the amount fields within this type.
This field only applies when DiscountName is EachAdditionalPercentOff.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

#    Argument: 'xs:float'

=cut

sub setEachAdditionalPercentOff {
  my $self = shift;
  $self->{'EachAdditionalPercentOff'} = shift
}

=head2 getEachAdditionalPercentOff()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

#    Returns: 'xs:float'

=cut

sub getEachAdditionalPercentOff {
  my $self = shift;
  return $self->{'EachAdditionalPercentOff'};
}


=head2 setOrderHandlingAmount()

If specified, this is the fixed shipping cost to charge for an order,
regardless of the number of items in the order.
This field is mutually exclusive with the other amount and percentage
fields within this type.
This field only applies when DiscountName is CombinedHandlingFee.

  Calls: SetShippingDiscountProfiles
  RequiredInput: Conditionally

#    Argument: 'ns:AmountType'

=cut

sub setOrderHandlingAmount {
  my $self = shift;
  $self->{'OrderHandlingAmount'} = shift
}

=head2 getOrderHandlingAmount()

  Calls: GetShippingDiscountProfiles
  Returned: Conditionally

#    Returns: 'ns:AmountType'

=cut

sub getOrderHandlingAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'OrderHandlingAmount'
		,'eBay::API::XML::DataType::AmountType');
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
